/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBraceBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.items.TimberFrameItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.mehvahdjukaar.suppsquared.SuppSquaredClient;
import net.mehvahdjukaar.suppsquared.client.ClientPackProvider;
import net.mehvahdjukaar.suppsquared.common.ColoredSackBlock;
import net.mehvahdjukaar.suppsquared.common.CopperLanternBlock;
import net.mehvahdjukaar.suppsquared.common.CrimsonLanternBlock;
import net.mehvahdjukaar.suppsquared.common.HeavyKeyItem;
import net.mehvahdjukaar.suppsquared.common.LightableLanternBlock;
import net.mehvahdjukaar.suppsquared.common.PlaqueBlock;
import net.mehvahdjukaar.suppsquared.common.PlaqueBlockTile;
import net.mehvahdjukaar.suppsquared.common.SackDyeRecipe;
import net.mehvahdjukaar.suppsquared.common.ServerPackProvider;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuppSquared {
    public static final String MOD_ID = "suppsquared";
    public static final Logger LOGGER = LogManager.getLogger((String)"suppsquared");
    public static Supplier<Boolean> PLAQUES;
    public static Supplier<Boolean> LANTERNS;
    private static final TagKey<Item> CANDLE_HOLDERS;
    private static final RegHelper.VariantType[] TYPES;
    public static final Supplier<DataComponentType<UUID>> HEAVY_KEY_UUID;
    public static final Supplier<RecipeSerializer<SackDyeRecipe>> SACK_DYE_RECIPE;
    public static final Map<RegHelper.VariantType, Supplier<Block>> DAUBS;
    public static final Map<RegHelper.VariantType, Supplier<Block>> FRAMES;
    public static final Map<WoodType, Block> ITEM_SHELVES;
    public static final Map<DyeColor, Supplier<ColoredSackBlock>> SACKS;
    public static final Map<DyeColor, Supplier<Item>> SACK_ITEMS;
    public static final Map<DyeColor, Supplier<Block>> GOLDEN_CANDLE_HOLDERS;
    public static final RegSupplier<FrameBlock> IRON_FRAME;
    public static final Supplier<Item> IRON_FRAME_ITEM;
    public static final Supplier<FrameBraceBlock> IRON_BRACE;
    public static final Supplier<Item> TIMBER_BRACE_ITEM;
    public static final Supplier<FrameBlock> IRON_CROSS_BRACE;
    public static final Supplier<Item> TIMBER_CROSS_BRACE_ITEM;
    public static final Supplier<PlaqueBlock> GOLD_PLAQUE;
    public static final Supplier<PlaqueBlock> IRON_PLAQUE;
    public static final Supplier<PlaqueBlock> COPPER_PLAQUE;
    public static final Supplier<BlockEntityType<PlaqueBlockTile>> PLAQUE_TILE;
    public static final Supplier<HeavyKeyItem> SKELETON_KEY;
    public static final Supplier<Block> COPPER_LANTERN;
    public static final Supplier<Block> BRASS_LANTERN;
    public static final Supplier<Block> CRIMSON_LANTERN;
    private static final List<Vec3> S2_FLOOR_1;
    private static final List<Vec3> S2_FLOOR_3;
    private static final List<Vec3> S2_FLOOR_3f;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        if (PlatHelper.getPhysicalSide().isClient()) {
            SuppSquaredClient.init();
            RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)new ClientPackProvider());
        }
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)new ServerPackProvider());
        BlockSetAPI.addDynamicBlockRegistration(SuppSquared::registerItemShelves, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(SuppSquared::registerItemShelfItems, WoodType.class);
        ModCreativeTabs.SYNCED_ADD_TO_TABS.add(SuppSquared::addItemsToTabs);
        PlatHelper.addCommonSetup(SuppSquared::commonSetup);
        ConfigBuilder builder = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON_SYNCED);
        builder.push("features");
        builder.comment("Enable plaques");
        PLAQUES = builder.define("plaques", true);
        builder.comment("Enable lanterns");
        LANTERNS = builder.define("lanterns", true);
        builder.pop();
        builder.build().forceLoad();
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)SuppSquared.res("flag"), a -> switch (a) {
            case "plaques" -> PLAQUES.get();
            case "lanterns" -> LANTERNS.get();
            default -> true;
        });
        RegHelper.addExtraBEBlockStatesRegistration(SuppSquared::addExtraBlockStates);
    }

    private static void addExtraBlockStates(RegHelper.ExtraBEStatesEvent event) {
        event.addBlocks((BlockEntityType)ModRegistry.SACK_TILE.get(), (Block[])SACKS.values().stream().filter(i -> i != ModRegistry.SACK.get()).map(Supplier::get).toArray(Block[]::new));
        event.addBlocks((BlockEntityType)ModRegistry.ITEM_SHELF_TILE.get(), ITEM_SHELVES.values().stream().filter(i -> i != ModRegistry.ITEM_SHELF.get()).toList().toArray(new Block[0]));
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        if (((Boolean)CommonConfigs.Building.TIMBER_FRAME_ENABLED.get()).booleanValue()) {
            event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is((Item)ModRegistry.TIMBER_CROSS_BRACE_ITEM.get()), new ItemLike[]{(ItemLike)IRON_FRAME.get(), (ItemLike)IRON_BRACE.get(), (ItemLike)IRON_CROSS_BRACE.get()});
        }
        if (((Boolean)CommonConfigs.Building.DAUB_ENABLED.get()).booleanValue()) {
            event.addAfter(CreativeModeTabs.BUILDING_BLOCKS, i -> i.is(((Block)ModRegistry.DAUB.get()).asItem()), new ItemLike[]{(ItemLike)DAUBS.get(RegHelper.VariantType.STAIRS).get(), (ItemLike)DAUBS.get(RegHelper.VariantType.SLAB).get()});
        }
        if (((Boolean)CommonConfigs.Building.WATTLE_AND_DAUB_ENABLED.get()).booleanValue()) {
            event.addAfter(CreativeModeTabs.BUILDING_BLOCKS, i -> i.is(((Block)ModRegistry.DAUB_CROSS_BRACE.get()).asItem()), new ItemLike[]{(ItemLike)FRAMES.get(RegHelper.VariantType.STAIRS).get(), (ItemLike)FRAMES.get(RegHelper.VariantType.SLAB).get()});
        }
        if (((Boolean)CommonConfigs.Building.CANDLE_HOLDER_ENABLED.get()).booleanValue()) {
            // empty if block
        }
        if (CommonConfigs.isEnabled((String)"key")) {
            event.addAfter(CreativeModeTabs.TOOLS_AND_UTILITIES, i -> i.is(((KeyItem)ModRegistry.KEY_ITEM.get()).asItem()), new ItemLike[]{(ItemLike)SKELETON_KEY.get()});
        }
        if (((Boolean)CommonConfigs.Functional.SACK_ENABLED.get()).booleanValue()) {
            event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is((Item)ModRegistry.SACK_ITEM.get()), (ItemLike[])SACK_ITEMS.values().stream().map(Supplier::get).toArray(Item[]::new));
            event.addBefore(CreativeModeTabs.COLORED_BLOCKS, i -> i.is(Items.SHULKER_BOX), new ItemLike[]{(ItemLike)ModRegistry.SACK_ITEM.get()});
            event.addAfter(CreativeModeTabs.COLORED_BLOCKS, i -> i.is((Item)ModRegistry.SACK_ITEM.get()), (ItemLike[])SACK_ITEMS.values().stream().map(Supplier::get).toArray(Item[]::new));
        }
        if (((Boolean)CommonConfigs.Building.ITEM_SHELF_ENABLED.get()).booleanValue()) {
            Block[] array = (Block[])ITEM_SHELVES.values().stream().filter(i -> i != ModRegistry.ITEM_SHELF.get()).toArray(Block[]::new);
            event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(((Block)ModRegistry.ITEM_SHELF.get()).asItem()), (ItemLike[])array);
        }
        if (LANTERNS.get().booleanValue()) {
            if (SuppSquared.isTagOn("c:brass_ingots") || SuppSquared.isTagOn("forge:ingots/brass")) {
                event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(Items.SOUL_LANTERN), new ItemLike[]{(ItemLike)BRASS_LANTERN.get()});
            }
            event.addAfter(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(Items.SOUL_LANTERN), new ItemLike[]{(ItemLike)COPPER_LANTERN.get(), (ItemLike)CRIMSON_LANTERN.get()});
        }
        if (PLAQUES.get().booleanValue()) {
            event.addBefore(CreativeModeTabs.FUNCTIONAL_BLOCKS, i -> i.is(((Block)ModRegistry.DOORMAT.get()).asItem()) || i.is(((Block)ModRegistry.ITEM_SHELF.get()).asItem()) || i.is(Items.CHEST), new ItemLike[]{(ItemLike)IRON_PLAQUE.get(), (ItemLike)COPPER_PLAQUE.get(), (ItemLike)GOLD_PLAQUE.get()});
        }
    }

    private static boolean isTagOn(String tag) {
        return BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag))).isPresent();
    }

    public static void commonSetup() {
    }

    private static void registerItemShelves(Registrator<Block> event, Collection<WoodType> types) {
        for (WoodType wood : types) {
            Block instance;
            if (wood == VanillaWoodTypes.OAK) {
                instance = (Block)ModRegistry.ITEM_SHELF.get();
            } else {
                String name = wood.getVariantId("item_shelf");
                ItemShelfBlock block = new ItemShelfBlock(wood.copyProperties().sound(SoundType.WOOD).strength(0.75f, 0.1f).noOcclusion().noCollission());
                instance = block;
                event.register(SuppSquared.res(name), (Object)block);
            }
            wood.addChild("supplementaries:item_shelf", (Object)instance);
            ITEM_SHELVES.put(wood, instance);
        }
    }

    public static void registerItemShelfItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (Map.Entry<WoodType, Block> entry : ITEM_SHELVES.entrySet()) {
            WoodType wood = entry.getKey();
            if (wood == VanillaWoodTypes.OAK) continue;
            Block block = entry.getValue();
            WoodBasedBlockItem item = new WoodBasedBlockItem(block, new Item.Properties(), wood);
            event.register(Utils.getID((Block)block), (Object)item);
        }
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)SuppSquared.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)SuppSquared.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return SuppSquared.regWithItem(name, blockFactory, new Item.Properties());
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties) {
        RegSupplier<T> block = SuppSquared.regBlock(name, blockFactory);
        SuppSquared.regBlockItem(name, block, properties);
        return block;
    }

    public static RegSupplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties) {
        return RegHelper.registerItem((ResourceLocation)SuppSquared.res(name), () -> new BlockItem((Block)blockSup.get(), properties));
    }

    public static List<Vec3> getGoldenCandleHolderParticleOffsets(BlockState state) {
        AttachFace face = (AttachFace)state.getValue((Property)CandleHolderBlock.FACE);
        if (face == AttachFace.FLOOR) {
            Direction direction = (Direction)state.getValue((Property)CandleHolderBlock.FACING);
            int candles = (Integer)state.getValue((Property)CandleHolderBlock.CANDLES);
            if (candles == 1) {
                return S2_FLOOR_1;
            }
            if (candles == 3) {
                return direction.getAxis() == Direction.Axis.Z ? S2_FLOOR_3 : S2_FLOOR_3f;
            }
        }
        return CandleHolderBlock.getParticleOffsets((BlockState)state);
    }

    static {
        CANDLE_HOLDERS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"supplementaries:candle_holders"));
        TYPES = (RegHelper.VariantType[])List.of(RegHelper.VariantType.SLAB, RegHelper.VariantType.STAIRS).toArray(RegHelper.VariantType[]::new);
        HEAVY_KEY_UUID = RegHelper.registerDataComponent((ResourceLocation)SuppSquared.res("heavy_key_uuid"), () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
        SACK_DYE_RECIPE = RegHelper.registerSpecialRecipe((ResourceLocation)SuppSquared.res("sack_dye"), SackDyeRecipe::new);
        DAUBS = RegHelper.registerBlockSet((RegHelper.VariantType[])TYPES, (RegSupplier)ModRegistry.DAUB, (String)MOD_ID);
        FRAMES = RegHelper.registerBlockSet((RegHelper.VariantType[])TYPES, (RegSupplier)ModRegistry.DAUB_FRAME, (String)MOD_ID);
        ITEM_SHELVES = new LinkedHashMap<WoodType, Block>();
        SACKS = (Map)Util.make(() -> {
            LinkedHashMap<DyeColor, RegSupplier<ColoredSackBlock>> map = new LinkedHashMap<DyeColor, RegSupplier<ColoredSackBlock>>();
            for (DyeColor c : BlocksColorAPI.SORTED_COLORS) {
                map.put(c, SuppSquared.regBlock("sack_" + c.getName(), () -> new ColoredSackBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(c).pushReaction(PushReaction.DESTROY).strength(0.8f).sound((SoundType)ModSounds.SACK), c)));
            }
            return map;
        });
        SACK_ITEMS = (Map)Util.make(() -> {
            LinkedHashMap<DyeColor, Supplier<Item>> map = new LinkedHashMap<DyeColor, Supplier<Item>>();
            for (DyeColor c : BlocksColorAPI.SORTED_COLORS) {
                map.put(c, SuppSquared.regItem("sack_" + c.getName(), () -> new SackItem((Block)SACKS.get(c).get(), new Item.Properties().stacksTo(1))));
            }
            return map;
        });
        GOLDEN_CANDLE_HOLDERS = RegUtils.registerCandleHolders((ResourceLocation)SuppSquared.res("gold_candle_holder"), SuppSquared::getGoldenCandleHolderParticleOffsets);
        IRON_FRAME = SuppSquared.regBlock("metal_frame", () -> new FrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(5.0f, 6.0f).mapColor(DyeColor.GRAY).dynamicShape().requiresCorrectToolForDrops().sound(SoundType.METAL)));
        IRON_FRAME_ITEM = SuppSquared.regItem("metal_frame", () -> new TimberFrameItem((Block)IRON_FRAME.get(), new Item.Properties()));
        IRON_BRACE = SuppSquared.regBlock("metal_brace", () -> new FrameBraceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)IRON_FRAME.get()))));
        TIMBER_BRACE_ITEM = SuppSquared.regItem("metal_brace", () -> new TimberFrameItem((Block)IRON_BRACE.get(), new Item.Properties()));
        IRON_CROSS_BRACE = SuppSquared.regBlock("metal_cross_brace", () -> new FrameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)IRON_FRAME.get()))));
        TIMBER_CROSS_BRACE_ITEM = SuppSquared.regItem("metal_cross_brace", () -> new TimberFrameItem((Block)IRON_CROSS_BRACE.get(), new Item.Properties()));
        GOLD_PLAQUE = SuppSquared.regWithItem("gold_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).mapColor(MapColor.NONE).sound(SoundType.METAL).requiresCorrectToolForDrops().noCollission().strength(1.0f, 1.0f)));
        IRON_PLAQUE = SuppSquared.regWithItem("iron_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GOLD_PLAQUE.get()))));
        COPPER_PLAQUE = SuppSquared.regWithItem("copper_plaque", () -> new PlaqueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GOLD_PLAQUE.get()))));
        PLAQUE_TILE = RegHelper.registerBlockEntityType((ResourceLocation)SuppSquared.res("plaque"), () -> PlatHelper.newBlockEntityType(PlaqueBlockTile::new, (Block[])new Block[]{(Block)IRON_PLAQUE.get(), (Block)COPPER_PLAQUE.get(), (Block)GOLD_PLAQUE.get()}));
        SKELETON_KEY = RegHelper.registerItem((ResourceLocation)SuppSquared.res("heavy_key"), () -> new HeavyKeyItem(new Item.Properties().fireResistant().stacksTo(1).rarity(Rarity.UNCOMMON)));
        COPPER_LANTERN = SuppSquared.regWithItem("copper_lantern", () -> new CopperLanternBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(3.5f).requiresCorrectToolForDrops().lightLevel(state -> (Boolean)state.getValue((Property)LightableLanternBlock.LIT) != false ? 15 : 0).sound(SoundType.COPPER)));
        BRASS_LANTERN = SuppSquared.regWithItem("brass_lantern", () -> new LightableLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COPPER_LANTERN.get())), Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)})));
        CRIMSON_LANTERN = SuppSquared.regWithItem("crimson_lantern", () -> new CrimsonLanternBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).mapColor(DyeColor.RED).ignitedByLava().strength(1.5f).lightLevel(state -> 15).noOcclusion()));
        S2_FLOOR_1 = List.of(new Vec3(0.5, 0.875, 0.5));
        S2_FLOOR_3 = List.of(new Vec3(0.1875, 0.875, 0.5), new Vec3(0.5, 0.9375, 0.5), new Vec3(0.8125, 0.875, 0.5));
        S2_FLOOR_3f = List.of(new Vec3(0.5, 0.875, 0.1875), new Vec3(0.5, 0.9375, 0.5), new Vec3(0.5, 0.875, 0.8125));
    }
}

