/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ChunkMapMixin;
import noppes.npcs.mixin.PersistentEntitySectionManagerMixin;
import noppes.npcs.mixin.ServerLevelMixin;

public class NPCSpawning {
    public static void findChunksForSpawning(ServerLevel level) {
        ChunkHolder chunkHolder;
        LevelChunk levelchunk;
        if (SpawnController.instance.data.isEmpty() || level.getGameTime() % 400L != 0L) {
            return;
        }
        EntitySectionStorage sectionManager = ((PersistentEntitySectionManagerMixin)((ServerLevelMixin)level).entityManager()).sectionStorage();
        ChunkMap chunkManager = level.getChunkSource().chunkMap;
        ArrayList list = new ArrayList(((ChunkMapMixin)chunkManager).visibleChunkMap().values());
        Collections.shuffle(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (levelchunk = (chunkHolder = (ChunkHolder)iterator.next()).getTickingChunk()) != null) {
            ChunkPos pos = levelchunk.getPos();
            Biome biome = (Biome)level.getBiome(pos.getWorldPosition()).value();
            if (!SpawnController.instance.hasSpawnList(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome))) continue;
            AABB bb = new AABB((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ(), (double)pos.getMaxBlockX(), (double)level.getMaxBuildHeight(), (double)pos.getMaxBlockZ());
            ArrayList entities = Lists.newArrayList();
            sectionManager.getEntities((EntityTypeTest)EntityType.PLAYER, bb.inflate(4.0), e -> {
                entities.add(e);
                return AbortableIterationConsumer.Continuation.CONTINUE;
            });
            if (!entities.isEmpty()) continue;
            sectionManager.getEntities(CustomEntities.entityCustomNpc, bb, e -> {
                entities.add(e);
                return AbortableIterationConsumer.Continuation.CONTINUE;
            });
            if (entities.size() >= CustomNpcs.NpcNaturalSpawningChunkLimit) continue;
            NPCSpawning.spawnChunk(level, levelchunk);
        }
    }

    private static void spawnChunk(ServerLevel level, LevelChunk chunk) {
        BlockPos chunkposition = NPCSpawning.getChunk((Level)level, chunk);
        int j1 = chunkposition.getX();
        int k1 = chunkposition.getY();
        int l1 = chunkposition.getZ();
        for (int i = 0; i < 3; ++i) {
            int x = j1;
            int y = k1;
            int z = l1;
            int b1 = 6;
            BlockPos pos = new BlockPos(x += level.random.nextInt(b1) - level.random.nextInt(b1), y, z += level.random.nextInt(b1) - level.random.nextInt(b1));
            ResourceLocation name = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)level.getBiome(pos).value()));
            SpawnData data = SpawnController.instance.getRandomSpawnData(name);
            if (data == null || data.data.isEmpty() || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (LevelReader)level, pos)) continue;
            NPCSpawning.spawnData(data, (ServerLevelAccessor)level, pos);
        }
    }

    public static int countNPCs(ServerLevel level) {
        int count = 0;
        Iterable list = level.getAllEntities();
        for (Entity entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    private static BlockPos getChunk(Level level, LevelChunk chunk) {
        ChunkPos chunkpos = chunk.getPos();
        int i = chunkpos.getMinBlockX() + level.random.nextInt(16);
        int j = chunkpos.getMinBlockZ() + level.random.nextInt(16);
        int k = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = level.random.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static void performLevelGenSpawning(ServerLevelAccessor level, Biome biome, int x, int z, RandomSource rand) {
        if (biome.getMobSettings().getCreatureProbability() >= 1.0f || biome.getMobSettings().getCreatureProbability() < 0.0f || !SpawnController.instance.hasSpawnList(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome))) {
            return;
        }
        int tries = 0;
        block0: while (rand.nextFloat() < biome.getMobSettings().getCreatureProbability() && ++tries <= 20) {
            SpawnData data = SpawnController.instance.getRandomSpawnData(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome));
            int size = 16;
            int j1 = x + rand.nextInt(size);
            int k1 = z + rand.nextInt(size);
            int l1 = j1;
            int i2 = k1;
            for (int k2 = 0; k2 < 4; ++k2) {
                BlockPos pos = NPCSpawning.getTopNonCollidingPos((LevelReader)level, CustomEntities.entityCustomNpc, j1, k1);
                if (!NPCSpawning.canCreatureTypeSpawnAtLocation(data, (LevelReader)level, pos)) {
                    j1 += rand.nextInt(5) - rand.nextInt(5);
                    k1 += rand.nextInt(5) - rand.nextInt(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.nextInt(5) - rand.nextInt(5);
                        k1 = i2 + rand.nextInt(5) - rand.nextInt(5);
                    }
                    continue;
                }
                if (NPCSpawning.spawnData(data, level, pos)) continue block0;
            }
        }
    }

    private static boolean spawnData(SpawnData data, ServerLevelAccessor level, BlockPos pos) {
        Mob entityliving;
        try {
            CompoundTag nbt = data.getCompound(1);
            if (nbt == null) {
                return false;
            }
            Entity entity = EntityType.create((CompoundTag)nbt, (Level)level.getLevel()).orElse(null);
            if (entity == null || !(entity instanceof Mob)) {
                return false;
            }
            entityliving = (Mob)entity;
            if (entity instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)entity;
                npc.stats.spawnCycle = 4;
                npc.stats.respawnTime = 0;
                npc.ais.returnToStart = false;
                npc.ais.setStartPos(pos);
            }
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, level.getRandom().nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (!entityliving.checkSpawnRules((LevelAccessor)level, MobSpawnType.NATURAL) || !entityliving.checkSpawnObstruction((LevelReader)level)) {
            return false;
        }
        level.getServer().submit(() -> level.addFreshEntity((Entity)entityliving));
        return true;
    }

    public static float getLightLevel(LevelReader level, BlockPos pos) {
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        int skyDarken = level.getSkyDarken();
        float skyLightValue = (11.0f - (float)skyDarken) * 15.0f / 11.0f;
        return Math.max((float)blockLight, (float)skyLight / 15.0f * skyLightValue);
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, LevelReader level, BlockPos pos) {
        if (!level.getWorldBorder().isWithinBounds(pos) || !level.noCollision(CustomEntities.entityCustomNpc.getSpawnAABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) {
            return false;
        }
        if (data.type == 1 && NPCSpawning.getLightLevel(level, pos) > 8.0f || data.type == 2 && NPCSpawning.getLightLevel(level, pos) <= 8.0f) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (data.liquid) {
            return state.liquid() && level.getBlockState(pos.below()).liquid() && !level.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)level, pos.above());
        }
        BlockPos blockpos1 = pos.below();
        BlockState state1 = level.getBlockState(blockpos1);
        Block block1 = state1.getBlock();
        boolean flag = block1 != Blocks.BEDROCK && block1 != Blocks.BARRIER;
        BlockPos down = blockpos1.below();
        return (flag |= level.getBlockState(down).isValidSpawn((BlockGetter)level, down, CustomEntities.entityCustomNpc)) && !state.isSignalSource() && !state.liquid() && !level.getBlockState(pos.above()).isSignalSource();
    }

    private static BlockPos getTopNonCollidingPos(LevelReader p_208498_0_, EntityType<?> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        BlockPos blockpos;
        int i = p_208498_0_.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, p_208498_2_, p_208498_3_);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_208498_2_, i, p_208498_3_);
        if (p_208498_0_.dimensionType().hasCeiling()) {
            do {
                blockpos$mutable.move(Direction.DOWN);
            } while (!p_208498_0_.getBlockState((BlockPos)blockpos$mutable).isAir());
            do {
                blockpos$mutable.move(Direction.DOWN);
            } while (p_208498_0_.getBlockState((BlockPos)blockpos$mutable).isAir() && blockpos$mutable.getY() > 0);
        }
        if (p_208498_0_.getBlockState(blockpos = blockpos$mutable.below()).isPathfindable(PathComputationType.LAND)) {
            return blockpos;
        }
        return blockpos$mutable.immutable();
    }
}

