/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;

public class NpcMiscInventory
extends SimpleContainer {
    public final NonNullList<ItemStack> items;
    public int stackLimit = 64;
    private int size;

    public NpcMiscInventory(int size) {
        super(new ItemStack[0]);
        this.size = size;
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public CompoundTag getToNBT(HolderLookup.Provider lookupProvider) {
        CompoundTag nbttagcompound = new CompoundTag();
        nbttagcompound.put("NpcMiscInv", (Tag)NBTTags.nbtItemStackList(lookupProvider, this.items));
        return nbttagcompound;
    }

    public void setFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        NBTTags.getItemStackList(lookupProvider, nbttagcompound.getList("NpcMiscInv", 10), this.items);
    }

    public int getContainerSize() {
        return this.size;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    public boolean removeItem(ItemStack eating, int decrease) {
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack item = (ItemStack)this.items.get(slot);
            if (item.isEmpty() || eating != item || item.getCount() < decrease) continue;
            item.split(decrease);
            if (item.getCount() <= 0) {
                this.items.set(slot, (Object)ItemStack.EMPTY);
            }
            return true;
        }
        return false;
    }

    public ItemStack removeItemNoUpdate(int var1) {
        return (ItemStack)this.items.set(var1, (Object)ItemStack.EMPTY);
    }

    public void setItem(int var1, ItemStack var2) {
        if (var1 >= this.getContainerSize()) {
            return;
        }
        this.items.set(var1, (Object)var2);
    }

    public int getMaxStackSize() {
        return this.stackLimit;
    }

    public boolean stillValid(Player var1) {
        return true;
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void setChanged() {
    }

    public boolean addItemStack(ItemStack item) {
        ItemStack mergable;
        boolean merged = false;
        while (!(mergable = this.getMergableItem(item)).isEmpty() && mergable.getCount() > 0) {
            int size = mergable.getMaxStackSize() - mergable.getCount();
            if (size > item.getCount()) {
                mergable.setCount(mergable.getMaxStackSize());
                item.setCount(item.getCount() - size);
                merged = true;
                continue;
            }
            mergable.setCount(mergable.getCount() + item.getCount());
            item.setCount(0);
        }
        if (item.getCount() <= 0) {
            return true;
        }
        int slot = this.firstFreeSlot();
        if (slot >= 0) {
            this.items.set(slot, (Object)item.copy());
            item.setCount(0);
            return true;
        }
        return merged;
    }

    public ItemStack getMergableItem(ItemStack item) {
        for (ItemStack is : this.items) {
            if (!NoppesUtilPlayer.compareItems(item, is, false, false) || is.getCount() >= is.getMaxStackSize()) continue;
            return is;
        }
        return ItemStack.EMPTY;
    }

    public int firstFreeSlot() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void setSize(int i) {
        this.size = i;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public void clearContent() {
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

