/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiCloneOpen;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.quests.QuestKill;

public class ServerEventsHandler {
    public static Villager Merchant;

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        ItemStack item = event.getEntity().getMainHandItem();
        if (item.isEmpty() || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        boolean isClientSide = event.getEntity().level().isClientSide;
        boolean npcInteracted = event.getTarget() instanceof EntityNPCInterface;
        if (!isClientSide && CustomNpcs.OpsOnly && !event.getEntity().getServer().getPlayerList().isOp(event.getEntity().getGameProfile())) {
            return;
        }
        if (!isClientSide && item.getItem() == CustomItems.soulstoneEmpty && event.getTarget() instanceof LivingEntity) {
            ((ItemSoulstoneEmpty)item.getItem()).store((LivingEntity)event.getTarget(), item, event.getEntity());
        }
        if (item.getItem() == CustomItems.wand && npcInteracted && !isClientSide) {
            if (!CustomNpcsPermissions.hasPermission((ServerPlayer)event.getEntity(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.getEntity(), EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.getTarget());
        } else if (item.getItem() == CustomItems.cloner && !isClientSide && !(event.getTarget() instanceof Player)) {
            CompoundTag compound = new CompoundTag();
            if (!event.getTarget().saveAsPassenger(compound)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getEntity());
            ServerCloneController.Instance.cleanTags(compound);
            Packets.send((ServerPlayer)event.getEntity(), new PacketGuiCloneOpen(compound));
            data.cloned = compound;
            event.setCanceled(true);
        } else if (item.getItem() == CustomItems.scripter && !isClientSide && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission((ServerPlayer)event.getEntity(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            NoppesUtilServer.setEditingNpc(event.getEntity(), (EntityNPCInterface)event.getTarget());
            event.setCanceled(true);
            Packets.send((ServerPlayer)event.getEntity(), new PacketGuiOpen(EnumGuiType.Script, BlockPos.ZERO));
        } else if (item.getItem() == CustomItems.mount && !isClientSide) {
            if (!CustomNpcsPermissions.hasPermission((ServerPlayer)event.getEntity(), CustomNpcsPermissions.TOOL_MOUNTER)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getEntity());
            event.setCanceled(true);
            data.mounted = event.getTarget();
            Packets.send((ServerPlayer)event.getEntity(), new PacketGuiOpen(EnumGuiType.MobSpawnerMounter, BlockPos.ZERO));
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (source != null) {
            if (source instanceof EntityNPCInterface && event.getEntity() != null) {
                EntityNPCInterface npc = (EntityNPCInterface)source;
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(Line.formatTarget(line, event.getEntity()));
                }
                EventHooks.onNPCKills(npc, event.getEntity());
            }
            Player player = null;
            if (source instanceof Player) {
                player = (Player)source;
            } else if (source instanceof EntityNPCInterface && ((EntityNPCInterface)source).getOwner() instanceof Player) {
                player = (Player)((EntityNPCInterface)source).getOwner();
            }
            if (player != null) {
                this.doQuest(player, event.getEntity(), true);
                if (event.getEntity() instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.getEntity());
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            PlayerData data = PlayerData.get((Player)event.getEntity());
            data.save(false);
        }
    }

    private void doFactionPoints(Player player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(Player player, LivingEntity entity, boolean all) {
        PlayerData pdata = PlayerData.get(player);
        PlayerQuestData playerdata = pdata.questData;
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        if (entity instanceof Player) {
            entityName = "Player";
        }
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != 2 && data.quest.type != 4) continue;
            if (data.quest.type == 4 && all) {
                List list = player.level().getEntitiesOfClass(Player.class, entity.getBoundingBox().inflate(10.0, 10.0, 10.0));
                for (Player pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.getName().getString())) {
                name = entity.getName().getString();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            pdata.updateClient = true;
        }
        playerdata.checkQuestCompletion(player, 2);
        playerdata.checkQuestCompletion(player, 4);
    }

    @SubscribeEvent
    public void world(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide || !(event.getEntity() instanceof Player)) {
            return;
        }
        PlayerData data = PlayerData.get((Player)event.getEntity());
        data.updateCompanion(event.getLevel());
    }

    @SubscribeEvent
    public void commandGive(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (!command.startsWith("/give ")) {
            return;
        }
        try {
            CommandContext context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString());
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            for (ServerPlayer player : players) {
                player.getServer().execute((Runnable)ListenableFutureTask.create(Executors.callable(() -> {
                    PlayerQuestData playerdata = PlayerData.get((Player)player).questData;
                    playerdata.checkQuestCompletion((Player)player, 0);
                })));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void commandTime(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (!command.startsWith("time ")) {
            return;
        }
        try {
            CustomNpcs.Server.submit(() -> {
                List players = CustomNpcs.Server.getPlayerList().getPlayers();
                for (ServerPlayer playerMP : players) {
                    VisibilityController.instance.onUpdate(playerMP);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

