/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIAttackTarget
extends Goal {
    private Level level;
    private EntityNPCInterface npc;
    private LivingEntity entityTarget;
    private int attackTick = 0;
    private Path entityPathEntity;
    private int field_75445_i;
    private BlockPos startPos = BlockPos.ZERO;

    public EntityAIAttackTarget(EntityNPCInterface par1EntityLiving) {
        this.npc = par1EntityLiving;
        this.level = par1EntityLiving.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity entitylivingbase = this.npc.getTarget();
        if (entitylivingbase == null || !entitylivingbase.isAlive()) {
            return false;
        }
        int melee = this.npc.stats.ranged.getMeleeRange();
        if (!(this.npc.inventory.getProjectile() == null || melee > 0 && this.npc.isInRange((Entity)entitylivingbase, melee))) {
            return false;
        }
        this.entityTarget = entitylivingbase;
        this.entityPathEntity = this.npc.getNavigation().createPath((Entity)entitylivingbase, 0);
        return this.entityPathEntity != null;
    }

    public boolean canContinueToUse() {
        this.entityTarget = this.npc.getTarget();
        if (this.entityTarget == null) {
            this.entityTarget = this.npc.getLastHurtByMob();
        }
        if (this.entityTarget == null || !this.entityTarget.isAlive()) {
            return false;
        }
        if (!this.npc.isInRange((Entity)this.entityTarget, this.npc.stats.aggroRange)) {
            return false;
        }
        int melee = this.npc.stats.ranged.getMeleeRange();
        if (melee > 0 && !this.npc.isInRange((Entity)this.entityTarget, melee)) {
            return false;
        }
        return this.isWithinRestriction(this.entityTarget.blockPosition());
    }

    public boolean isWithinRestriction(BlockPos pos) {
        int range = Math.max(this.npc.stats.aggroRange * 2, 64);
        return this.startPos.distSqr((Vec3i)pos) < (double)(range * range);
    }

    public void start() {
        this.startPos = this.npc.blockPosition();
        this.npc.getNavigation().moveTo(this.entityPathEntity, 1.3);
        this.field_75445_i = 0;
    }

    public void stop() {
        this.entityPathEntity = null;
        this.entityTarget = null;
        this.npc.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        this.npc.getLookControl().setLookAt((Entity)this.entityTarget, 30.0f, 30.0f);
        if (--this.field_75445_i <= 0) {
            this.field_75445_i = 4 + this.npc.getRandom().nextInt(7);
            this.npc.getNavigation().moveTo((Entity)this.entityTarget, (double)1.3f);
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        double y = this.entityTarget.getY();
        if (this.entityTarget.getBoundingBox() != null) {
            y = this.entityTarget.getBoundingBox().minY;
        }
        double distance = this.npc.distanceToSqr(this.entityTarget.getX(), y, this.entityTarget.getZ());
        double range = (float)(this.npc.stats.melee.getRange() * this.npc.stats.melee.getRange()) + this.entityTarget.getBbWidth();
        double minRange = this.npc.getBbWidth() * 2.0f * this.npc.getBbWidth() * 2.0f + this.entityTarget.getBbWidth();
        if (minRange > range) {
            range = minRange;
        }
        if (distance <= range && (this.npc.canNpcSee((Entity)this.entityTarget) || distance < minRange) && this.attackTick <= 0) {
            this.attackTick = this.npc.stats.melee.getDelay();
            this.npc.swing(InteractionHand.MAIN_HAND);
            this.npc.doHurtTarget((Entity)this.entityTarget);
        }
    }
}

