/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIWatchClosest
extends Goal {
    private EntityNPCInterface npc;
    protected Entity closestEntity;
    private float maxDistance;
    private int lookTime;
    private float change;
    private Class<? extends LivingEntity> watchedClass;
    protected final TargetingConditions predicate;

    public EntityAIWatchClosest(EntityNPCInterface par1EntityLiving, Class<? extends LivingEntity> limbSwingAmountClass, float par3) {
        this.npc = par1EntityLiving;
        this.watchedClass = limbSwingAmountClass;
        this.maxDistance = par3;
        this.change = 0.002f;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        this.predicate = TargetingConditions.forNonCombat().range((double)par3);
    }

    public boolean canUse() {
        if (this.npc.getRandom().nextFloat() >= this.change || this.npc.isInteracting()) {
            return false;
        }
        if (this.npc.getTarget() != null) {
            this.closestEntity = this.npc.getTarget();
        }
        if (this.watchedClass == Player.class) {
            this.closestEntity = this.npc.level().getNearestPlayer((Entity)this.npc, (double)this.maxDistance);
        } else {
            this.closestEntity = this.npc.level().getNearestEntity(this.watchedClass, this.predicate, (LivingEntity)this.npc, this.npc.getX(), this.npc.getEyeY(), this.npc.getZ(), this.npc.getBoundingBox().inflate((double)this.maxDistance, 3.0, (double)this.maxDistance));
            if (this.closestEntity != null) {
                return this.npc.canNpcSee(this.closestEntity);
            }
        }
        return this.closestEntity != null;
    }

    public boolean canContinueToUse() {
        if (this.npc.isInteracting() || this.npc.isAttacking() || !this.closestEntity.isAlive() || !this.npc.isAlive()) {
            return false;
        }
        return !this.npc.isInRange(this.closestEntity, this.maxDistance) ? false : this.lookTime > 0;
    }

    public void start() {
        this.lookTime = 60 + this.npc.getRandom().nextInt(60);
    }

    public void stop() {
        this.closestEntity = null;
    }

    public void tick() {
        this.npc.getLookControl().setLookAt(this.closestEntity.getX(), this.closestEntity.getY() + (double)this.closestEntity.getEyeHeight(), this.closestEntity.getZ(), 10.0f, (float)this.npc.getMaxHeadXRot());
        --this.lookTime;
    }
}

