/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import noppes.npcs.ItemStackEmptyWrapper;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IMob;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemArmorWrapper;
import noppes.npcs.api.wrapper.ItemBlockWrapper;
import noppes.npcs.api.wrapper.ItemBookWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.items.ItemDataComponents;
import noppes.npcs.items.ItemScripted;

public class ItemStackWrapper
implements IItemStack {
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private static Map<Integer, ItemStackWrapper> dataMap = new HashMap<Integer, ItemStackWrapper>();
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public ItemStack item;
    private CompoundTag storedData = new CompoundTag();
    public static ItemStackWrapper AIR = new ItemStackEmptyWrapper();
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            ItemStackWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return ItemStackWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.tempData.keySet().toArray(new String[ItemStackWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            boolean changed = false;
            if (value instanceof Number) {
                ItemStackWrapper.this.storedData.putDouble(key, ((Number)value).doubleValue());
                changed = true;
            } else if (value instanceof String) {
                ItemStackWrapper.this.storedData.putString(key, (String)value);
                changed = true;
            }
            if (changed) {
                ItemStackWrapper.this.item.set(ItemDataComponents.STORED_DATA, (Object)CustomData.of((CompoundTag)ItemStackWrapper.this.storedData));
            }
        }

        @Override
        public Object get(String key) {
            if (!ItemStackWrapper.this.storedData.contains(key)) {
                return null;
            }
            Tag base = ItemStackWrapper.this.storedData.get(key);
            if (base instanceof NumericTag) {
                return ((NumericTag)base).getAsDouble();
            }
            return base.getAsString();
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.storedData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.storedData.contains(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.storedData = new CompoundTag();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.storedData.getAllKeys().toArray(new String[ItemStackWrapper.this.storedData.getAllKeys().size()]);
        }
    };
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "itemscripteddata");

    public ItemStackWrapper(ItemStack item) {
        this.item = item;
        if (item == null || !item.has(ItemDataComponents.STORED_DATA)) {
            return;
        }
        this.storedData = ((CustomData)item.get(ItemDataComponents.STORED_DATA)).getUnsafe();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public int getStackSize() {
        return this.item.getCount();
    }

    @Override
    public void setStackSize(int size) {
        if (size > this.getMaxStackSize()) {
            throw new CustomNPCsException("Can't set the stacksize bigger than MaxStacksize", new Object[0]);
        }
        this.item.setCount(size);
    }

    @Override
    public void setAttribute(String name, double value) {
        this.setAttribute(name, value, -1);
    }

    @Override
    public void setAttribute(String name, double value, int slot) {
        if (slot < -1 || slot > 5) {
            throw new CustomNPCsException("Slot has to be between -1 and 5, given was: " + slot, new Object[0]);
        }
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.item.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        List nbttaglist = modifiers.modifiers();
        ArrayList<ItemAttributeModifiers.Entry> newList = new ArrayList<ItemAttributeModifiers.Entry>();
        for (ItemAttributeModifiers.Entry entry : nbttaglist) {
            if (entry.modifier().id().toString().equals(name)) continue;
            newList.add(entry);
        }
        if (value != 0.0) {
            AttributeModifier modifier = new AttributeModifier(ResourceLocation.tryParse((String)name), value, AttributeModifier.Operation.ADD_VALUE);
            EquipmentSlotGroup group = slot >= 0 ? EquipmentSlotGroup.bySlot((EquipmentSlot)EquipmentSlot.values()[slot]) : EquipmentSlotGroup.ANY;
            newList.add(new ItemAttributeModifiers.Entry(Holder.direct((Object)((Attribute)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.tryParse((String)name)))), modifier, group));
        }
        this.item.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(newList, modifiers.showInTooltip()));
    }

    @Override
    public double getAttribute(String name) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.item.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!entry.modifier().id().toString().equals(name)) continue;
            return entry.modifier().amount();
        }
        return 0.0;
    }

    @Override
    public boolean hasAttribute(String name) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.item.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!entry.modifier().id().toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEnchantment(String id, int strenght) {
        Enchantment ench = (Enchantment)NBTTags.access.compositeAccess().registryOrThrow(Registries.ENCHANTMENT).get(ResourceLocation.tryParse((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        this.item.enchant(Holder.direct((Object)ench), strenght);
    }

    @Override
    public boolean isEnchanted() {
        return this.item.isEnchanted();
    }

    @Override
    public boolean hasEnchant(String id) {
        Enchantment ench = (Enchantment)NBTTags.access.compositeAccess().registryOrThrow(Registries.ENCHANTMENT).get(ResourceLocation.tryParse((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        ItemEnchantments enchantments = (ItemEnchantments)this.item.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return enchantments.getLevel(Holder.direct((Object)ench)) > 0;
    }

    @Override
    public boolean removeEnchant(String id) {
        Enchantment ench = (Enchantment)NBTTags.access.compositeAccess().registryOrThrow(Registries.ENCHANTMENT).get(ResourceLocation.tryParse((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.item);
        ItemEnchantments.Mutable newList = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            if (((ResourceKey)((Holder)entry.getKey()).unwrapKey().get()).toString().equalsIgnoreCase(id)) continue;
            newList.set(Holder.direct((Object)((Enchantment)((Holder)entry.getKey()).value())), entry.getIntValue());
        }
        if (enchantments.size() == newList.keySet().size()) {
            return false;
        }
        this.item.set(DataComponents.ENCHANTMENTS, (Object)newList.toImmutable());
        return true;
    }

    @Override
    public boolean isBlock() {
        Block block = Block.byItem((Item)this.item.getItem());
        return block != null && block != Blocks.AIR;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.has(DataComponents.CUSTOM_NAME);
    }

    @Override
    public void setCustomName(String name) {
        this.item.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)name));
    }

    @Override
    public String getDisplayName() {
        return this.item.getHoverName().getString();
    }

    @Override
    public String getItemName() {
        return this.item.getItem().getName(this.item).getString();
    }

    @Override
    public String getName() {
        return BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()).toString();
    }

    @Override
    public INbt getNbt() {
        if (this.item.getComponents() == DataComponentMap.EMPTY) {
            return NpcAPI.Instance().getINbt(new CompoundTag());
        }
        PatchedDataComponentMap data = (PatchedDataComponentMap)this.item.getComponents();
        return NpcAPI.Instance().getINbt((CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data.asPatch()).getOrThrow());
    }

    @Override
    public boolean hasNbt() {
        return !this.item.getComponents().isEmpty();
    }

    @Override
    public ItemStack getMCItemStack() {
        return this.item;
    }

    public static ItemStack MCItem(IItemStack item) {
        if (item == null) {
            return ItemStack.EMPTY;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IMob living) {
        if (living != null) {
            this.item.hurtAndBreak(damage, living == null ? null : (LivingEntity)living.getMCEntity(), EquipmentSlot.MAINHAND);
        } else if (this.item.isDamageableItem()) {
            if (this.item.getDamageValue() <= damage) {
                this.item.shrink(1);
                this.item.setDamageValue(0);
            } else {
                this.item.setDamageValue(this.item.getDamageValue() - damage);
            }
        }
    }

    @Override
    public boolean isBook() {
        return false;
    }

    @Override
    public int getFoodLevel() {
        if (this.item.has(DataComponents.FOOD)) {
            return ((FoodProperties)this.item.get(DataComponents.FOOD)).nutrition();
        }
        return 0;
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.createNew(this.item.copy());
    }

    @Override
    public int getMaxStackSize() {
        return this.item.getMaxStackSize();
    }

    @Override
    public boolean isDamageable() {
        return this.item.isDamageableItem();
    }

    @Override
    public int getDamage() {
        return this.item.getDamageValue();
    }

    @Override
    public void setDamage(int value) {
        this.item.setDamageValue(value);
    }

    @Deprecated
    public int getItemDamage() {
        return this.item.getDamageValue();
    }

    @Deprecated
    public void setItemDamage(int value) {
        this.item.setDamageValue(value);
    }

    @Override
    public int getMaxDamage() {
        return this.item.getMaxDamage();
    }

    @Override
    public INbt getItemNbt() {
        CompoundTag compound = (CompoundTag)this.item.save(NBTTags.getProvider());
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public double getAttackDamage() {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)this.item.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        double damage = 0.0;
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!((Attribute)entry.attribute().value()).equals(Attributes.ATTACK_DAMAGE)) continue;
            damage = entry.modifier().amount();
        }
        return damage;
    }

    @Override
    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    @Override
    public int getType() {
        if (this.item.getItem() instanceof SwordItem) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isWearable() {
        return this.item.getItem() instanceof Equipable;
    }

    private static ItemStackWrapper createNew(ItemStack item) {
        if (item == null || item.isEmpty()) {
            return AIR;
        }
        if (item.getItem() instanceof ItemScripted) {
            return new ItemScriptedWrapper(item);
        }
        if (item.getItem() == Items.WRITTEN_BOOK || item.getItem() == Items.WRITABLE_BOOK || item.getItem() instanceof WritableBookItem || item.getItem() instanceof WrittenBookItem) {
            return new ItemBookWrapper(item);
        }
        if (item.getItem() instanceof ArmorItem) {
            return new ItemArmorWrapper(item);
        }
        Block block = Block.byItem((Item)item.getItem());
        if (block != Blocks.AIR) {
            return new ItemBlockWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public String[] getLore() {
        if (!this.item.has(DataComponents.LORE)) {
            return new String[0];
        }
        List lore = ((ItemLore)this.item.get(DataComponents.LORE)).lines();
        if (lore.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> loreStr = new ArrayList<String>();
        for (Component line : lore) {
            loreStr.add(line.getString());
        }
        return loreStr.toArray(new String[lore.size()]);
    }

    @Override
    public void setLore(String[] lore) {
        if (lore == null || lore.length == 0) {
            this.item.remove(DataComponents.LORE);
            return;
        }
        ItemLore itemLore = new ItemLore(new ArrayList());
        for (String s : lore) {
            try {
                MutableComponent comp = Component.Serializer.fromJson((String)s, (HolderLookup.Provider)NBTTags.getProvider());
                if (comp == null) continue;
                itemLore = itemLore.withLineAdded((Component)comp);
            }
            catch (JsonParseException jsonparseexception) {
                itemLore = itemLore.withLineAdded((Component)Component.translatable((String)s));
            }
        }
        this.item.set(DataComponents.LORE, (Object)itemLore);
    }

    public CompoundTag serializeNBT() {
        return this.getMCNbt();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setMCNbt(nbt);
    }

    public CompoundTag getMCNbt() {
        CompoundTag compound = new CompoundTag();
        if (!this.storedData.isEmpty()) {
            compound.put("StoredData", (Tag)this.storedData);
        }
        return compound;
    }

    public void setMCNbt(CompoundTag compound) {
        this.storedData = compound == null || !compound.contains("StoredData") ? new CompoundTag() : compound.getCompound("StoredData");
    }

    @Override
    public void removeNbt() {
        this.item.applyComponents(DataComponentMap.EMPTY);
    }

    @Override
    public boolean compare(IItemStack item, boolean ignoreNBT) {
        if (item == null) {
            item = AIR;
        }
        return NoppesUtilPlayer.compareItems(this.getMCItemStack(), item.getMCItemStack(), false, ignoreNBT);
    }
}

