/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockBuilder
extends BlockInterface {
    public static final MapCodec<BlockBuilder> CODEC = BlockBuilder.simpleCodec(BlockBuilder::new);
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);

    public BlockBuilder() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    public BlockBuilder(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == CustomItems.wand || stack.getItem() == CustomBlocks.builder_item) {
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.BuilderBlock, null, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int var6 = Mth.floor((double)((double)(context.getPlayer().getYRot() / 90.0f) + 0.5)) & 3;
        if (!context.getLevel().isClientSide) {
            SPacketGuiOpen.sendOpenGui(context.getPlayer(), EnumGuiType.BuilderBlock, null, context.getClickedPos());
        }
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(var6));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileBuilder(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (TileBuilder.DrawPos != null && TileBuilder.DrawPos.equals((Object)pos)) {
            TileBuilder.SetDrawPos(null);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockBuilder.createTickerHelper(type, CustomBlocks.tile_builder, TileBuilder::tick);
    }
}

