/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiQuestLog;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerKeyPressed;
import noppes.npcs.packets.server.SPacketQuestCompletionCheckAll;
import noppes.npcs.packets.server.SPacketSceneReset;
import noppes.npcs.packets.server.SPacketSceneStart;

public class ClientTickHandler {
    private Level prevLevel;
    private boolean otherContainer = false;
    private final int[] ignoreKeys = new int[]{341, 340, 342, 343, 345, 344, 346, 347};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.containerMenu instanceof InventoryMenu) {
            if (this.otherContainer) {
                Packets.sendServer(new SPacketQuestCompletionCheckAll());
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        ++CustomNpcs.ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (this.prevLevel != mc.level) {
            this.prevLevel = mc.level;
            MusicController.Instance.stopMusic();
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null || mc.getConnection() == null) {
            return;
        }
        if (CustomNpcs.SceneButtonsEnabled) {
            if (ClientProxy.Scene1.isDown()) {
                Packets.sendServer(new SPacketSceneStart(1));
            }
            if (ClientProxy.Scene2.isDown()) {
                Packets.sendServer(new SPacketSceneStart(2));
            }
            if (ClientProxy.Scene3.isDown()) {
                Packets.sendServer(new SPacketSceneStart(3));
            }
            if (ClientProxy.SceneReset.isDown()) {
                Packets.sendServer(new SPacketSceneReset());
            }
        }
        if (ClientProxy.QuestLog.isDown()) {
            if (mc.screen == null) {
                NoppesUtil.openGUI((Player)mc.player, new GuiQuestLog((Player)mc.player));
            } else if (mc.screen instanceof GuiQuestLog) {
                mc.mouseHandler.grabMouse();
            }
        }
        if (event.getAction() == 1 || event.getAction() == 0) {
            boolean isCtrlPressed = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)345);
            boolean isShiftPressed = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
            boolean isAltPressed = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)342) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)346);
            boolean isMetaPressed = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)343) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)347);
            String openGui = mc.screen == null ? "" : mc.screen.getClass().getName();
            Packets.sendServer(new SPacketPlayerKeyPressed(event.getKey(), isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, event.getAction() == 0, openGui));
        }
    }

    private boolean isIgnoredKey(int key) {
        for (int i : this.ignoreKeys) {
            if (i != key) continue;
            return true;
        }
        return false;
    }
}

