/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import noppes.npcs.items.ItemNpcBlock;

public class CustomTileEntityItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static CustomTileEntityItemStackRenderer i = null;
    public static IClientItemExtensions itemRenderProperties = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return CustomTileEntityItemStackRenderer.instance();
        }
    };
    private HashMap<Block, BlockEntity> data = new HashMap();
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public CustomTileEntityItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet model) {
        super(dispatcher, model);
        this.blockEntityRenderDispatcher = dispatcher;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext p_239207_2_, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (stack.getItem() instanceof ItemNpcBlock) {
            ItemNpcBlock item = (ItemNpcBlock)stack.getItem();
            BlockEntity tile = this.data.get(item.block);
            if (tile == null) {
                tile = ((BaseEntityBlock)item.block).newBlockEntity(BlockPos.ZERO, item.block.defaultBlockState());
                this.data.put(item.block, tile);
            }
            this.blockEntityRenderDispatcher.renderItem(tile, matrixStack, buffer, combinedLight, combinedOverlay);
        }
    }

    public static CustomTileEntityItemStackRenderer instance() {
        if (i != null) {
            return i;
        }
        Minecraft mc = Minecraft.getInstance();
        i = new CustomTileEntityItemStackRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
        return i;
    }
}

