/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketNbtBookBlockSave;
import noppes.npcs.packets.server.SPacketNbtBookEntitySave;
import noppes.npcs.shared.client.gui.GuiTextAreaScreen;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.listeners.IGuiData;

public class GuiNbtBook
extends GuiNPCInterface
implements IGuiData {
    private BlockPos pos;
    private BlockEntity tile;
    private BlockState state;
    private ItemStack blockStack;
    private int entityId;
    private Entity entity;
    private CompoundTag originalCompound;
    private CompoundTag compound;
    private String faultyText = null;
    private String errorMessage = null;

    public GuiNbtBook(BlockPos pos) {
        this.pos = pos;
        this.setBackground("menubg.png");
        this.imageWidth = 256;
        this.imageHeight = 216;
    }

    @Override
    public void init() {
        super.init();
        int y = this.guiTop + 40;
        if (this.state != null) {
            this.addLabel(new GuiLabel(11, "x: " + this.pos.getX() + ", y: " + this.pos.getY() + ", z: " + this.pos.getZ(), this.guiLeft + 60, this.guiTop + 6));
            this.addLabel(new GuiLabel(12, "id: " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock())), this.guiLeft + 60, this.guiTop + 16));
        }
        if (this.entity != null) {
            this.addLabel(new GuiLabel(12, "id: " + this.entity.getType().getDescriptionId(), this.guiLeft + 60, this.guiTop + 6));
        }
        this.addButton(new GuiButtonNop(this, 0, this.guiLeft + 38, this.guiTop + 144, 180, 20, "nbt.edit"));
        this.getButton((int)0).active = this.compound != null && !this.compound.isEmpty();
        this.addLabel(new GuiLabel(0, "", this.guiLeft + 4, this.guiTop + 167));
        this.addLabel(new GuiLabel(1, "", this.guiLeft + 4, this.guiTop + 177));
        this.addButton(new GuiButtonNop(this, 66, this.guiLeft + 128, this.guiTop + 190, 120, 20, "gui.close"));
        this.addButton(new GuiButtonNop(this, 67, this.guiLeft + 4, this.guiTop + 190, 120, 20, "gui.save"));
        if (this.errorMessage != null) {
            this.getButton((int)67).active = false;
            int i = this.errorMessage.indexOf(" at: ");
            if (i > 0) {
                this.getLabel(0).setMessage((Component)Component.translatable((String)this.errorMessage.substring(0, i)));
                this.getLabel(1).setMessage((Component)Component.translatable((String)this.errorMessage.substring(i)));
            } else {
                this.getLabel(0).setMessage((Component)Component.translatable((String)this.errorMessage));
            }
        }
        if (this.getButton((int)67).active && this.originalCompound != null) {
            this.getButton((int)67).active = !this.originalCompound.equals((Object)this.compound);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        int id = guibutton.id;
        if (id == 0) {
            if (this.faultyText != null) {
                this.setSubGui(new GuiTextAreaScreen(this.compound.toString(), this.faultyText).enableHighlighting());
            } else {
                this.setSubGui(new GuiTextAreaScreen(this.compound.toString()).enableHighlighting());
            }
        }
        if (id == 67) {
            this.getLabel(0).setMessage((Component)Component.translatable((String)"Saved"));
            if (this.compound.equals((Object)this.originalCompound)) {
                return;
            }
            if (this.tile == null) {
                Packets.sendServer(new SPacketNbtBookEntitySave(this.entityId, this.compound));
                return;
            }
            Packets.sendServer(new SPacketNbtBookBlockSave(this.pos, this.compound));
            this.originalCompound = this.compound.copy();
            this.getButton((int)67).active = false;
        }
        if (id == 66) {
            this.close();
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.hasSubGui()) {
            return;
        }
        PoseStack matrixStack = graphics.pose();
        if (this.state != null) {
            matrixStack.pushPose();
            matrixStack.translate((float)(this.guiLeft + 4), (float)(this.guiTop + 4), 0.0f);
            matrixStack.scale(3.0f, 3.0f, 3.0f);
            graphics.renderItem(this.blockStack, 0, 0);
            graphics.renderItemDecorations(this.font, this.blockStack, 0, 0);
            matrixStack.popPose();
        }
        if (this.entity instanceof LivingEntity) {
            this.drawNpc(graphics, (LivingEntity)this.entity, 20, 80, 1.0f, 0);
        }
    }

    @Override
    public void subGuiClosed(Screen gui) {
        if (gui instanceof GuiTextAreaScreen) {
            try {
                this.compound = TagParser.parseTag((String)((GuiTextAreaScreen)gui).text);
                this.faultyText = null;
                this.errorMessage = null;
            }
            catch (CommandSyntaxException e) {
                this.errorMessage = e.getLocalizedMessage();
                this.faultyText = ((GuiTextAreaScreen)gui).text;
            }
            this.init();
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundTag compound) {
        if (compound.contains("EntityId")) {
            this.entityId = compound.getInt("EntityId");
            this.entity = this.player.level().getEntity(this.entityId);
        } else {
            this.tile = this.player.level().getBlockEntity(this.pos);
            this.state = this.player.level().getBlockState(this.pos);
            this.blockStack = this.state.getBlock().getCloneItemStack((LevelReader)this.player.level(), this.pos, this.state);
        }
        this.originalCompound = compound.getCompound("Data");
        this.compound = this.originalCompound.copy();
        this.init();
    }
}

