/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.gui.custom.GuiCustomComponents;
import noppes.npcs.client.gui.custom.GuiCustomScrollingPanel;
import noppes.npcs.client.gui.custom.components.CustomGuiTexturedRect;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.client.gui.util.GuiTooltipUtils;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCustomGuiSubGuiClosed;
import noppes.npcs.shared.client.gui.listeners.IGuiData;
import org.joml.Matrix4fStack;

public class GuiCustom
extends AbstractContainerScreen<ContainerCustomGui>
implements IGuiData {
    protected CustomGuiTexturedRect background;
    public CustomGuiWrapper guiWrapper;
    public List<Component> hoverText;
    protected GuiCustomComponents components = new GuiCustomComponents();
    protected GuiCustomScrollingPanel scrollingPanel = new GuiCustomScrollingPanel();
    public GuiCustom subgui = null;
    public GuiCustom parent = null;
    public Inventory inv;
    public InitCallback initCallback;

    public GuiCustom(ContainerCustomGui container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.inv = inv;
    }

    public void init() {
        super.init();
        if (this.guiWrapper != null) {
            this.scrollingPanel.setComponents(this, this.guiWrapper.getScrollingPanel());
            this.components.setComponents(this, this.guiWrapper);
        }
        if (this.initCallback != null) {
            this.initCallback.init();
        }
        if (this.subgui != null) {
            this.subgui.init();
        }
    }

    public void containerTick() {
        if (this.subgui != null) {
            this.subgui.containerTick();
        } else {
            this.components.containerTick();
            this.scrollingPanel.containerTick();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoverText = null;
        PoseStack matrixStack = graphics.pose();
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        RenderSystem.applyModelViewMatrix();
        matrixStack.pushPose();
        if (this.background != null) {
            this.background.onRender(graphics, mouseX, mouseY, partialTicks);
        }
        this.components.render(graphics, mouseX - this.leftPos, mouseY - this.topPos, partialTicks);
        this.scrollingPanel.render(graphics, mouseX - this.leftPos, mouseY - this.topPos, partialTicks);
        if (this.hoverText != null && !this.hoverText.isEmpty() && this.subgui == null) {
            GuiTooltipUtils.renderTooltip(graphics, this.font, this.hoverText, Optional.empty(), mouseX - this.leftPos, mouseY - this.topPos);
        }
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.subgui == null) {
            this.renderTooltip(graphics, mouseX, mouseY);
        }
        matrixStack.popPose();
        if (this.subgui != null) {
            matrixStack.pushPose();
            posestack.pushMatrix();
            posestack.translate(0.0f, 0.0f, 40.0f);
            RenderSystem.applyModelViewMatrix();
            matrixStack.translate(0.0f, 0.0f, 40.0f);
            this.subgui.render(graphics, mouseX, mouseY, partialTicks);
            matrixStack.popPose();
            posestack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    protected void renderBg(GuiGraphics p_283065_, float p_97788_, int p_97789_, int p_97790_) {
    }

    protected void renderLabels(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.subgui != null) {
            return this.subgui.charTyped(typedChar, keyCode);
        }
        if (this.components.charTyped(typedChar, keyCode)) {
            return true;
        }
        if (this.scrollingPanel.charTyped(typedChar, keyCode)) {
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.subgui != null) {
            return this.subgui.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (this.components.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (this.scrollingPanel.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.subgui != null) {
            return this.subgui.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.components.mouseClicked(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton)) {
            return true;
        }
        if (this.scrollingPanel.mouseClicked(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseScrolled, double arg4) {
        if (this.subgui != null) {
            return this.subgui.mouseScrolled(mouseX, mouseY, mouseScrolled, arg4);
        }
        if (super.mouseScrolled(mouseX, mouseY, mouseScrolled, arg4)) {
            return true;
        }
        return this.scrollingPanel.mouseScrolled(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseScrolled);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.subgui != null) {
            return this.subgui.mouseDragged(mouseX, mouseY, mouseButton, dx, dy);
        }
        if (this.components.mouseDragged(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton, dx, dy)) {
            return true;
        }
        if (this.scrollingPanel.mouseDragged(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton, dx, dy)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.subgui != null) {
            return this.subgui.mouseReleased(mouseX, mouseY, mouseButton);
        }
        if (this.components.mouseReleased(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton)) {
            return true;
        }
        if (this.scrollingPanel.mouseReleased(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, mouseButton)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean isPauseScreen() {
        if (this.guiWrapper != null) {
            return this.guiWrapper.getDoesPauseGame();
        }
        return true;
    }

    public void onClose() {
        if (this.subgui == null) {
            if (this.parent == null) {
                super.onClose();
            } else {
                Packets.sendServer(new SPacketCustomGuiSubGuiClosed());
                this.parent.subgui = null;
            }
        } else {
            this.subgui.onClose();
        }
    }

    @Override
    public void setGuiData(CompoundTag compound) {
        this.setGuiWrapper((CustomGuiWrapper)new CustomGuiWrapper((IPlayer)NpcAPI.Instance().getIEntity((Entity)Minecraft.getInstance().player)).fromNBT(compound));
        this.init();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.subgui != null) {
            this.subgui.resize(minecraft, width, height);
        }
    }

    public void setGuiWrapper(CustomGuiWrapper guiWrapper) {
        this.guiWrapper = guiWrapper;
        this.imageWidth = guiWrapper.getWidth();
        this.imageHeight = guiWrapper.getHeight();
        this.background = new CustomGuiTexturedRect(this, (CustomGuiTexturedRectWrapper)guiWrapper.getBackgroundRect());
        if (guiWrapper.hasSubGui()) {
            if (this.subgui == null) {
                this.subgui = new GuiCustom((ContainerCustomGui)this.menu, Minecraft.getInstance().player.getInventory(), (Component)Component.empty());
                this.subgui.init(this.minecraft, this.width, this.height);
            }
            this.subgui.parent = this;
            this.subgui.setGuiWrapper(guiWrapper.getSubGui());
        } else {
            ((ContainerCustomGui)this.menu).setGui(guiWrapper, (Player)Minecraft.getInstance().player);
            this.subgui = null;
            if (this.parent == null) {
                this.init();
            }
        }
    }

    public IGuiComponent getComponent(UUID id) {
        Optional<IGuiComponent> c = this.components.components.values().stream().filter(t -> t.component() != null && t.component().getUniqueID().equals(id)).findFirst();
        if (c.isPresent()) {
            return c.get();
        }
        c = this.scrollingPanel.components.values().stream().filter(t -> t.component() != null && t.component().getUniqueID().equals(id)).findFirst();
        if (c.isPresent()) {
            return c.get();
        }
        if (this.subgui != null) {
            return this.subgui.getComponent(id);
        }
        return null;
    }

    public int getTotalGuiLeft() {
        if (this.parent != null) {
            return this.parent.getTotalGuiLeft() + this.leftPos;
        }
        return this.leftPos;
    }

    public int getTotalGuiTop() {
        if (this.parent != null) {
            return this.parent.getTotalGuiTop() + this.topPos;
        }
        return this.topPos;
    }

    public void add(IGuiComponent component) {
        this.components.components.put(component.getID(), component);
    }

    public void addPanel(IGuiComponent component) {
        this.scrollingPanel.components.put(component.getID(), component);
    }

    public static interface InitCallback {
        public void init();
    }
}

