/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemRendererWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.components.CustomGuiEntityDisplay;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiItemRenderer
extends AbstractWidget
implements IGuiComponent {
    private GuiCustom parent;
    public CustomGuiItemRendererWrapper component;
    private ItemStack stack;
    public int id;
    Minecraft minecraft;

    public CustomGuiItemRenderer(GuiCustom parent, CustomGuiItemRendererWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.empty());
        this.component = component;
        this.parent = parent;
        this.minecraft = Minecraft.getInstance();
        this.init();
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.setWidth(this.component.getWidth());
        this.height = this.component.getHeight();
        this.stack = this.component.hasStack() ? this.component.getStack().getMCItemStack() : ItemStack.EMPTY;
        this.active = true;
        this.visible = true;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            boolean hovered;
            if (!NoppesUtilServer.IsItemStackNull(this.stack)) {
                double scale = this.component.getScale();
                graphics.pose().pushPose();
                graphics.pose().scale((float)scale, (float)scale, 1.0f);
                graphics.pose().translate(0.0f, 0.0f, (float)this.id);
                graphics.renderItem(this.stack, (int)((double)this.getX() / scale), (int)((double)this.getY() / scale));
                graphics.renderItemDecorations(this.minecraft.font, this.stack, (int)((double)this.getX() / scale), (int)((double)this.getY() / scale));
                graphics.pose().popPose();
            }
            boolean bl = hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            if (hovered && this.component.hasHoverText()) {
                this.parent.hoverText = this.component.getHoverTextList();
            }
        }
    }

    protected int getYImage(boolean p_getYImage_1_) {
        return 0;
    }

    protected void renderWidget(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static CustomGuiEntityDisplay fromComponent(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        CustomGuiEntityDisplay btn = new CustomGuiEntityDisplay(parent, component);
        return btn;
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }
}

