/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;

public class CmdQuest {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.literal((String)"quest");
        command.then(Commands.literal((String)"start").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).then(Commands.argument((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                QuestData questdata = new QuestData(quest);
                data.questData.activeQuests.put(quest.id, questdata);
                data.save(true);
                Packets.send(player, new PacketAchievement((Component)Component.translatable((String)"quest.newquest"), (Component)Component.translatable((String)quest.title), 2));
                Packets.send(player, new PacketChat((Component)Component.translatable((String)"quest.newquest").append(":").append((Component)Component.translatable((String)quest.title))));
            }
            return 1;
        }))));
        command.then(Commands.literal((String)"finish").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).then(Commands.argument((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                data.questData.finishedQuests.put(quest.id, System.currentTimeMillis());
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.literal((String)"stop").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).then(Commands.argument((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                data.questData.activeQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).then(Commands.argument((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                data.questData.activeQuests.remove(quest.id);
                data.questData.finishedQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.literal((String)"objective").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            for (ServerPlayer player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((Player)player);
                if (!data.questData.activeQuests.containsKey(quest.id)) continue;
                for (IQuestObjective ob : objectives = quest.questInterface.getObjectives((Player)player)) {
                    player.sendSystemMessage(ob.getMCText());
                }
            }
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"objective", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            for (ServerPlayer player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((Player)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((Player)player)).length) continue;
                player.sendSystemMessage(objectives[objective].getMCText());
            }
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown QuestID")).create();
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            for (ServerPlayer player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((Player)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((Player)player)).length) continue;
                objectives[objective].setProgress(value);
            }
            return 1;
        }))))));
        ((LiteralArgumentBuilder)command.requires(source -> source.hasPermission(4))).then(Commands.literal((String)"reload").executes(context -> {
            new QuestController().load((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            SyncController.syncAllQuests((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            return 1;
        }));
        return command;
    }
}

