/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import noppes.npcs.CustomEntities;
import noppes.npcs.ModelData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityNPCGolem
extends EntityNPCInterface {
    public EntityNPCGolem(EntityType<? extends EntityNPCInterface> type, Level world) {
        super(type, world);
        this.display.setSkinTexture("customnpcs:textures/entity/golem/irongolem.png");
        this.baseSize = EntityDimensions.scalable((float)1.4f, (float)2.5f);
    }

    @Override
    public EntityDimensions getDimensions(Pose pos) {
        this.currentAnimation = (Integer)this.entityData.get(Animation);
        if (this.currentAnimation == 2) {
            return EntityDimensions.scalable((float)0.5f, (float)0.5f);
        }
        if (this.currentAnimation == 1) {
            return EntityDimensions.scalable((float)1.4f, (float)2.0f);
        }
        return EntityDimensions.scalable((float)1.4f, (float)2.5f);
    }

    @Override
    public void tick() {
        this.discard();
        this.setNoAi(true);
        if (!this.level().isClientSide) {
            CompoundTag compound = new CompoundTag();
            this.addAdditionalSaveData(compound);
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.level());
            npc.readAdditionalSaveData(compound);
            ModelData data = npc.modelData;
            data.setEntity(BuiltInRegistries.ENTITY_TYPE.getKey(CustomEntities.entityNPCGolem));
            this.level().addFreshEntity((Entity)npc);
        }
        super.tick();
    }
}

