/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemDataComponents;

public class ItemNpcMovingPath
extends Item {
    public ItemNpcMovingPath() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide || !CustomNpcsPermissions.hasPermission((ServerPlayer)player, CustomNpcsPermissions.TOOL_PATHER)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        EntityNPCInterface npc = this.getNpc(itemstack, level);
        if (npc != null) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.MovingPath, npc);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide || !CustomNpcsPermissions.hasPermission((ServerPlayer)context.getPlayer(), CustomNpcsPermissions.TOOL_PATHER)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        EntityNPCInterface npc = this.getNpc(stack, context.getLevel());
        if (npc == null) {
            return InteractionResult.PASS;
        }
        List<int[]> list = npc.ais.getMovingPath();
        int[] pos = list.get(list.size() - 1);
        int x = context.getClickedPos().getX();
        int y = context.getClickedPos().getY();
        int z = context.getClickedPos().getZ();
        list.add(new int[]{x, y, z});
        double d3 = x - pos[0];
        double d4 = y - pos[1];
        double d5 = z - pos[2];
        double distance = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
        context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.pather.added", (Object[])new Object[]{x, y, z, npc.getName()}));
        if (distance > (double)CustomNpcs.NpcNavRange) {
            ((ServerPlayer)context.getPlayer()).sendSystemMessage((Component)Component.translatable((String)"message.pather.farwarning", (Object[])new Object[]{CustomNpcs.NpcNavRange}));
        }
        return InteractionResult.SUCCESS;
    }

    private EntityNPCInterface getNpc(ItemStack item, Level level) {
        if (level.isClientSide || !item.has(ItemDataComponents.NPCID)) {
            return null;
        }
        Entity entity = level.getEntity(((Integer)item.get(ItemDataComponents.NPCID)).intValue());
        if (entity == null || !(entity instanceof EntityNPCInterface)) {
            return null;
        }
        return (EntityNPCInterface)entity;
    }
}

