/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiUpdate;

public class SPacketDialogSave
extends PacketServerBasic {
    private int category;
    private CompoundTag data;

    public SPacketDialogSave(int category, CompoundTag data) {
        this.data = data;
        this.category = category;
    }

    public SPacketDialogSave(FriendlyByteBuf buf) {
        this.category = buf.readInt();
        this.data = buf.readNbt();
    }

    public static SPacketDialogSave decode(FriendlyByteBuf buf) {
        return new SPacketDialogSave(buf);
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        return CustomNpcsPermissions.GLOBAL_DIALOG;
    }

    @Override
    protected void handle() {
        DialogCategory dcategory = DialogController.instance.categories.get(this.category);
        if (dcategory == null) {
            return;
        }
        Dialog dialog = new Dialog(dcategory);
        dialog.readNBT((HolderLookup.Provider)this.player.registryAccess(), this.data);
        DialogController.instance.saveDialog((HolderLookup.Provider)this.player.registryAccess(), dcategory, dialog);
        Packets.send(this.player, new PacketGuiUpdate());
    }

    public static void encode(SPacketDialogSave msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.category);
        buf.writeNbt((Tag)msg.data);
    }
}

