/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.role.IJobFarmer;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.data.BlockData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobFarmer
extends JobInterface
implements MassBlockController.IMassBlock,
IJobFarmer {
    public int chestMode = 1;
    private List<BlockPos> trackedBlocks = new ArrayList<BlockPos>();
    private int ticks = 0;
    private int walkTicks = 0;
    private int blockTicks = 800;
    private boolean waitingForBlocks = false;
    private BlockPos ripe = null;
    private BlockPos chest = null;
    private ItemStack holding = ItemStack.EMPTY;

    public JobFarmer(EntityNPCInterface npc) {
        super(npc);
        this.overrideMainHand = true;
    }

    @Override
    public IItemStack getMainhand() {
        String name = this.npc.getJobData();
        ItemStack item = this.stringToItem(name);
        if (item.isEmpty()) {
            return this.npc.inventory.weapons.get(0);
        }
        return NpcAPI.Instance().getIItemStack(item);
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        compound.putInt("JobChestMode", this.chestMode);
        if (!this.holding.isEmpty()) {
            compound.put("JobHolding", this.holding.save((HolderLookup.Provider)this.npc.registryAccess(), (Tag)new CompoundTag()));
        }
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        this.chestMode = compound.getInt("JobChestMode");
        this.holding = ItemStack.parseOptional((HolderLookup.Provider)this.npc.registryAccess(), (CompoundTag)compound.getCompound("JobHolding"));
        this.blockTicks = 1100;
    }

    public void setHolding(ItemStack item) {
        this.holding = item;
        this.npc.setJobData(this.itemToString(this.holding));
    }

    @Override
    public boolean aiShouldExecute() {
        if (!this.holding.isEmpty()) {
            if (this.chestMode == 0) {
                this.setHolding(ItemStack.EMPTY);
            } else if (this.chestMode == 1) {
                if (this.chest == null) {
                    this.dropItem(this.holding);
                    this.setHolding(ItemStack.EMPTY);
                } else {
                    this.chest();
                }
            } else if (this.chestMode == 2) {
                this.dropItem(this.holding);
                this.setHolding(ItemStack.EMPTY);
            }
            return false;
        }
        if (this.ripe != null) {
            this.pluck();
            return false;
        }
        if (!this.waitingForBlocks && this.blockTicks++ > 1200) {
            this.blockTicks = 0;
            this.waitingForBlocks = true;
            MassBlockController.Queue(this);
        }
        if (this.ticks++ < 100) {
            return false;
        }
        this.ticks = 0;
        return true;
    }

    private void dropItem(ItemStack item) {
        ItemEntity entityitem = new ItemEntity(this.npc.level(), this.npc.getX(), this.npc.getY(), this.npc.getZ(), item);
        entityitem.setDefaultPickUpDelay();
        this.npc.level().addFreshEntity((Entity)entityitem);
    }

    private void chest() {
        BlockPos pos = this.chest;
        this.npc.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
        this.npc.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0f, (float)this.npc.getMaxHeadXRot());
        if (this.npc.nearPosition(pos) || this.walkTicks++ > 400) {
            Container inventory;
            if (this.walkTicks < 400) {
                this.npc.swing(InteractionHand.MAIN_HAND);
            }
            this.npc.getNavigation().stop();
            this.ticks = 100;
            this.walkTicks = 0;
            BlockState state = this.npc.level().getBlockState(pos);
            BlockEntity tile = this.npc.level().getBlockEntity(pos);
            Container container = inventory = tile instanceof Container ? (Container)tile : null;
            if (state.getBlock() instanceof ChestBlock) {
                inventory = ChestBlock.getContainer((ChestBlock)((ChestBlock)state.getBlock()), (BlockState)state, (Level)this.npc.level(), (BlockPos)pos, (boolean)true);
            }
            if (inventory != null) {
                int i;
                for (i = 0; !this.holding.isEmpty() && i < inventory.getContainerSize(); ++i) {
                    this.holding = this.mergeStack(inventory, i, this.holding);
                }
                for (i = 0; !this.holding.isEmpty() && i < inventory.getContainerSize(); ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (!item.isEmpty()) continue;
                    inventory.setItem(i, this.holding);
                    this.holding = ItemStack.EMPTY;
                }
                if (!this.holding.isEmpty()) {
                    this.dropItem(this.holding);
                    this.holding = ItemStack.EMPTY;
                }
            } else {
                this.chest = null;
            }
            this.setHolding(this.holding);
        }
    }

    private ItemStack mergeStack(Container inventory, int slot, ItemStack item) {
        ItemStack item2 = inventory.getItem(slot);
        if (!NoppesUtilPlayer.compareItems(item, item2, false, false)) {
            return item;
        }
        int size = item2.getMaxStackSize() - item2.getCount();
        if (size >= item.getCount()) {
            item2.setCount(item2.getCount() + item.getCount());
            return ItemStack.EMPTY;
        }
        item2.setCount(item2.getMaxStackSize());
        item.setCount(item.getCount() - size);
        if (item.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return item;
    }

    private void pluck() {
        BlockPos pos = this.ripe;
        this.npc.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
        this.npc.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0f, (float)this.npc.getMaxHeadXRot());
        if (this.npc.nearPosition(pos) || this.walkTicks++ > 400) {
            if (this.walkTicks > 400) {
                pos = NoppesUtilServer.GetClosePos(pos, this.npc.level());
                this.npc.teleportTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            }
            this.ripe = null;
            this.npc.getNavigation().stop();
            this.ticks = 90;
            this.walkTicks = 0;
            this.npc.swing(InteractionHand.MAIN_HAND);
            BlockState state = this.npc.level().getBlockState(pos);
            Block b = state.getBlock();
            if (b instanceof CropBlock && ((CropBlock)b).isMaxAge(state)) {
                CropBlock crop = (CropBlock)b;
                Item item = crop.getCloneItemStack((LevelReader)this.npc.level(), pos, state).getItem();
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.npc.level()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)this.npc.getMainHandItem()).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this.npc.level().getBlockEntity(pos));
                LootTable loottable = this.npc.getServer().reloadableRegistries().getLootTable(b.getLootTable());
                ObjectArrayList l = loottable.getRandomItems(builder.create(LootContextParamSets.BLOCK));
                this.npc.level().setBlock(pos, crop.getStateForAge(0), 2);
                if (l.isEmpty()) {
                    this.holding = ItemStack.EMPTY;
                } else if (l.size() == 1) {
                    this.holding = (ItemStack)l.get(0);
                } else {
                    ObjectArrayList fl = l.stream().filter(t -> t.getItem() != item).collect(Collectors.toList());
                    if (fl.isEmpty()) {
                        fl = l;
                    }
                    this.holding = (ItemStack)fl.get(this.npc.getRandom().nextInt(fl.size()));
                }
                this.holding.setCount(1);
            }
            if (b == Blocks.PUMPKIN || b == Blocks.MELON) {
                b = this.npc.level().getBlockState(pos).getBlock();
                this.npc.level().removeBlock(pos, false);
                this.holding = new ItemStack((ItemLike)b);
            }
            this.setHolding(this.holding);
        }
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiUpdateTask() {
        Iterator<BlockPos> ite = this.trackedBlocks.iterator();
        while (ite.hasNext() && this.ripe == null) {
            BlockPos pos = ite.next();
            BlockState state = this.npc.level().getBlockState(pos);
            Block b = state.getBlock();
            if ((b instanceof CropBlock && ((CropBlock)b).isMaxAge(state) || b == Blocks.PUMPKIN || b == Blocks.MELON) && b.getLootTable() != BuiltInLootTables.EMPTY) {
                this.ripe = pos;
                continue;
            }
            ite.remove();
        }
        boolean bl = this.npc.ais.returnToStart = this.ripe == null;
        if (this.ripe != null) {
            this.npc.getNavigation().stop();
            this.npc.getLookControl().setLookAt((double)this.ripe.getX(), (double)this.ripe.getY(), (double)this.ripe.getZ(), 10.0f, (float)this.npc.getMaxHeadXRot());
        }
    }

    @Override
    public boolean isPlucking() {
        return this.ripe != null || !this.holding.isEmpty();
    }

    @Override
    public EntityNPCInterface getNpc() {
        return this.npc;
    }

    @Override
    public int getRange() {
        return 16;
    }

    @Override
    public void processed(List<BlockData> list) {
        ArrayList<BlockPos> trackedBlocks = new ArrayList<BlockPos>();
        BlockPos chest = null;
        for (BlockData data : list) {
            BlockEntity tile = this.npc.level().getBlockEntity(data.pos);
            Block b = data.state.getBlock();
            if (tile instanceof RandomizableContainerBlockEntity) {
                if (chest != null && !(this.npc.distanceToSqr(chest.getX(), chest.getY(), chest.getZ()) > this.npc.distanceToSqr(data.pos.getX(), data.pos.getY(), data.pos.getZ()))) continue;
                chest = data.pos;
                continue;
            }
            if (!(b instanceof CropBlock) && !(b instanceof StemBlock) || trackedBlocks.contains(data.pos)) continue;
            trackedBlocks.add(data.pos);
        }
        this.chest = chest;
        this.trackedBlocks = trackedBlocks;
        this.waitingForBlocks = false;
    }

    @Override
    public EnumSet<Goal.Flag> getFlags() {
        return EnumSet.of(Goal.Flag.MOVE);
    }

    @Override
    public int getType() {
        return 11;
    }
}

