/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.resources.ResourceLocation;

public class ValueUtil {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    public static float correctFloat(float given, float min, float max) {
        if (given < min) {
            return min;
        }
        if (given > max) {
            return max;
        }
        return given;
    }

    public static int CorrectInt(int given, int min, int max) {
        if (given < min) {
            return min;
        }
        if (given > max) {
            return max;
        }
        return given;
    }

    public static String nbtToJson(CompoundTag nbt) {
        return new Gson().toJson(ValueUtil.getJsonValue((Tag)nbt));
    }

    private static JsonElement getJsonValue(Tag value) {
        if (value.getType() == CompoundTag.TYPE) {
            CompoundTag nbt = (CompoundTag)value;
            JsonObject root = new JsonObject();
            for (String key : nbt.getAllKeys()) {
                Tag n = nbt.get(key);
                JsonElement ele = ValueUtil.getJsonValue(n);
                if (ele == null) continue;
                JsonObject ob = new JsonObject();
                ob.addProperty("type", n.getType().getName());
                ob.addProperty("type_id", (Number)n.getId());
                ob.addProperty("pretty_type", n.getType().getPrettyName());
                ob.add("value", ele);
                root.add(key, (JsonElement)ob);
            }
            return root;
        }
        if (value == StringTag.TYPE) {
            return new JsonPrimitive(value.getAsString());
        }
        if (value instanceof NumericTag) {
            return new JsonPrimitive(((NumericTag)value).getAsNumber());
        }
        if (value instanceof CollectionTag) {
            JsonArray jsonValue = new JsonArray();
            for (Tag n : (CollectionTag)value) {
                jsonValue.add(ValueUtil.getJsonValue(n));
            }
            return jsonValue;
        }
        return null;
    }

    public static CompoundTag jsonToNbt(String json) {
        JsonObject ob = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        return ValueUtil.toNbt(ob);
    }

    private static CompoundTag toNbt(JsonObject json) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry entry : json.entrySet()) {
            JsonArray array;
            String key = (String)entry.getKey();
            JsonObject ele = (JsonObject)entry.getValue();
            TagType<? extends Tag> type = ValueUtil.stringToType(ele.get("type").getAsString());
            if (type == StringTag.TYPE) {
                nbt.putString(key, ele.get("value").getAsString());
            }
            if (type == IntTag.TYPE) {
                nbt.putInt(key, ele.get("value").getAsInt());
            }
            if (type == ByteTag.TYPE) {
                nbt.putByte(key, ele.get("value").getAsByte());
            }
            if (type == LongTag.TYPE) {
                nbt.putLong(key, ele.get("value").getAsLong());
            }
            if (type == FloatTag.TYPE) {
                nbt.putFloat(key, ele.get("value").getAsFloat());
            }
            if (type == DoubleTag.TYPE) {
                nbt.putDouble(key, ele.get("value").getAsDouble());
            }
            if (type == ShortTag.TYPE) {
                nbt.putShort(key, ele.get("value").getAsShort());
            }
            if (type == CompoundTag.TYPE) {
                nbt.put(key, (Tag)ValueUtil.toNbt((JsonObject)ele.get("value")));
            }
            if (type == IntArrayTag.TYPE) {
                array = (JsonArray)ele.get("value");
                nbt.put(key, (Tag)new IntArrayTag(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsInt).collect(Collectors.toList())));
            }
            if (type == ByteArrayTag.TYPE) {
                array = (JsonArray)ele.get("value");
                nbt.put(key, (Tag)new ByteArrayTag(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsByte).collect(Collectors.toList())));
            }
            if (type != LongArrayTag.TYPE) continue;
            array = (JsonArray)ele.get("value");
            nbt.put(key, (Tag)new LongArrayTag(StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsLong).collect(Collectors.toList())));
        }
        return nbt;
    }

    private static TagType<? extends Tag> stringToType(String type) {
        if (type.equals(IntTag.TYPE.getName())) {
            return IntTag.TYPE;
        }
        if (type.equals(ByteTag.TYPE.getName())) {
            return ByteTag.TYPE;
        }
        if (type.equals(FloatTag.TYPE.getName())) {
            return FloatTag.TYPE;
        }
        if (type.equals(LongTag.TYPE.getName())) {
            return LongTag.TYPE;
        }
        if (type.equals(DoubleTag.TYPE.getName())) {
            return DoubleTag.TYPE;
        }
        if (type.equals(ShortTag.TYPE.getName())) {
            return ShortTag.TYPE;
        }
        if (type.equals(CompoundTag.TYPE.getName())) {
            return CompoundTag.TYPE;
        }
        if (type.equals(IntArrayTag.TYPE.getName())) {
            return IntArrayTag.TYPE;
        }
        if (type.equals(ByteArrayTag.TYPE.getName())) {
            return ByteArrayTag.TYPE;
        }
        if (type.equals(LongArrayTag.TYPE.getName())) {
            return LongArrayTag.TYPE;
        }
        return StringTag.TYPE;
    }

    public static boolean isValidPath(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (ResourceLocation.validPathChar((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

