/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.status;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TaskStatusBuilder {
    private final TaskStatus.TaskInfo info;
    private final TaskState state;
    private final Map<ResourceKey, MutableItem> items = new LinkedHashMap<ResourceKey, MutableItem>();

    public TaskStatusBuilder(TaskId id, TaskState state, ResourceKey resource, long amount, long startTime) {
        this.info = new TaskStatus.TaskInfo(id, resource, amount, startTime);
        this.state = state;
    }

    public void stored(ResourceKey resource, long stored) {
        CoreValidations.validateLargerThanZero(stored, "Stored");
        this.get((ResourceKey)resource).stored += stored;
    }

    public void extracting(ResourceKey resource, long extracting) {
        CoreValidations.validateLargerThanZero(extracting, "Extracting");
        this.get((ResourceKey)resource).extracting += extracting;
    }

    public void processing(ResourceKey resource, long processing, @Nullable ExternalPatternSinkKey sinkKey) {
        CoreValidations.validateLargerThanZero(processing, "Processing");
        this.get((ResourceKey)resource).processing += processing;
        this.get((ResourceKey)resource).sinkKey = sinkKey;
    }

    public void scheduled(ResourceKey resource, long scheduled) {
        CoreValidations.validateLargerThanZero(scheduled, "Crafting");
        this.get((ResourceKey)resource).scheduled += scheduled;
    }

    public void crafting(ResourceKey resource, long crafting) {
        CoreValidations.validateLargerThanZero(crafting, "Crafting");
        this.get((ResourceKey)resource).crafting += crafting;
    }

    public void rejected(ResourceKey resource) {
        this.get((ResourceKey)resource).type = TaskStatus.ItemType.REJECTED;
    }

    public void noneFound(ResourceKey resource) {
        this.get((ResourceKey)resource).type = TaskStatus.ItemType.NONE_FOUND;
    }

    public void locked(ResourceKey resource) {
        this.get((ResourceKey)resource).type = TaskStatus.ItemType.LOCKED;
    }

    private MutableItem get(ResourceKey resource) {
        return this.items.computeIfAbsent(resource, key -> new MutableItem(TaskStatus.ItemType.NORMAL));
    }

    public TaskStatus build(double percentageCompleted) {
        List<TaskStatus.Item> mappedItems = this.items.entrySet().stream().map(entry -> new TaskStatus.Item((ResourceKey)entry.getKey(), ((MutableItem)entry.getValue()).type, ((MutableItem)entry.getValue()).sinkKey, ((MutableItem)entry.getValue()).stored, ((MutableItem)entry.getValue()).extracting, ((MutableItem)entry.getValue()).processing, ((MutableItem)entry.getValue()).scheduled, ((MutableItem)entry.getValue()).crafting)).toList();
        return new TaskStatus(this.info, this.state, percentageCompleted, mappedItems);
    }

    private static class MutableItem {
        private TaskStatus.ItemType type;
        private long stored;
        private long extracting;
        private long processing;
        @Nullable
        private ExternalPatternSinkKey sinkKey;
        private long scheduled;
        private long crafting;

        private MutableItem(TaskStatus.ItemType type) {
            this.type = type;
        }
    }
}

