/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.1")
public final class TransferHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferHelper.class);

    private TransferHelper() {
    }

    public static long transfer(ResourceKey resource, long amount, Actor actor, ExtractableStorage source, InsertableStorage destination, @Nullable InsertableStorage fallback) {
        long extractedSimulated = source.extract(resource, amount, Action.SIMULATE, actor);
        if (extractedSimulated == 0L) {
            return 0L;
        }
        long insertedSimulated = destination.insert(resource, extractedSimulated, Action.SIMULATE, actor);
        if (insertedSimulated == 0L) {
            return 0L;
        }
        long extracted = source.extract(resource, insertedSimulated, Action.EXECUTE, actor);
        if (extracted == 0L) {
            return 0L;
        }
        long inserted = destination.insert(resource, extracted, Action.EXECUTE, actor);
        long leftover = extracted - inserted;
        if (leftover > 0L) {
            if (fallback != null) {
                TransferHelper.handleLeftover(resource, actor, fallback, leftover);
            } else {
                throw new IllegalStateException("Destination storage did not accept resource from source storage, even after simulating");
            }
        }
        return inserted;
    }

    public static void handleLeftover(ResourceKey resource, Actor actor, InsertableStorage fallback, long leftover) {
        long leftoverInserted = fallback.insert(resource, leftover, Action.EXECUTE, actor);
        long leftoverNotInserted = leftover - leftoverInserted;
        if (leftoverNotInserted > 0L) {
            LOGGER.warn("Fallback didn't accept all leftovers, {} of {} has been voided", (Object)leftoverNotInserted, (Object)leftover);
        }
    }
}

