/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.limited;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.AbstractProxyStorage;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageImpl;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorage;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.2")
public class LimitedStorageImpl
extends AbstractProxyStorage
implements LimitedStorage {
    private final long capacity;

    public LimitedStorageImpl(Storage delegate, long capacity) {
        super(delegate);
        this.capacity = CoreValidations.validateNotNegative(capacity, "Capacity cannot be negative");
    }

    public LimitedStorageImpl(long capacity) {
        this(new StorageImpl(), capacity);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        long spaceRemaining = this.capacity - this.delegate.getStored();
        if (spaceRemaining == 0L) {
            return 0L;
        }
        long maxInsert = Math.min(amount, spaceRemaining);
        return super.insert(resource, maxInsert, action, actor);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }
}

