/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class AutocraftingMonitorStreamCodecs {
    public static final StreamCodec<RegistryFriendlyByteBuf, TaskId> TASK_ID_STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, TaskId::id, TaskId::new);
    private static final StreamCodec<RegistryFriendlyByteBuf, TaskStatus.Item> STATUS_ITEM_STREAM_CODEC = new StatusItemStreamCodec();
    private static final StreamCodec<RegistryFriendlyByteBuf, TaskStatus.TaskInfo> INFO_STREAM_CODEC = StreamCodec.composite(TASK_ID_STREAM_CODEC, TaskStatus.TaskInfo::id, ResourceCodecs.STREAM_CODEC, s -> (PlatformResourceKey)s.resource(), (StreamCodec)ByteBufCodecs.VAR_LONG, TaskStatus.TaskInfo::amount, (StreamCodec)ByteBufCodecs.VAR_LONG, TaskStatus.TaskInfo::startTime, TaskStatus.TaskInfo::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, TaskStatus> STATUS_STREAM_CODEC = StreamCodec.composite(INFO_STREAM_CODEC, TaskStatus::info, (StreamCodec)PlatformUtil.enumStreamCodec((Enum[])TaskState.values()), TaskStatus::state, (StreamCodec)ByteBufCodecs.DOUBLE, TaskStatus::percentageCompleted, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, STATUS_ITEM_STREAM_CODEC), TaskStatus::items, TaskStatus::new);

    private AutocraftingMonitorStreamCodecs() {
    }

    private static class StatusItemStreamCodec
    implements StreamCodec<RegistryFriendlyByteBuf, TaskStatus.Item> {
        private static final StreamCodec<ByteBuf, TaskStatus.ItemType> TYPE_STREAM_CODEC = PlatformUtil.enumStreamCodec((Enum[])TaskStatus.ItemType.values());

        private StatusItemStreamCodec() {
        }

        public TaskStatus.Item decode(RegistryFriendlyByteBuf buf) {
            return new TaskStatus.Item((ResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf), (TaskStatus.ItemType)((Object)TYPE_STREAM_CODEC.decode((Object)buf)), this.decodeSinkKey(buf), buf.readLong(), buf.readLong(), buf.readLong(), buf.readLong(), buf.readLong());
        }

        @Nullable
        private ExternalPatternSinkKey decodeSinkKey(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new InWorldExternalPatternSinkKey(buf.readUtf(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
            }
            return null;
        }

        public void encode(RegistryFriendlyByteBuf buf, TaskStatus.Item item) {
            ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)((PlatformResourceKey)item.resource()));
            TYPE_STREAM_CODEC.encode((Object)buf, (Object)item.type());
            this.encodeSinkKey(buf, item.sinkKey());
            buf.writeLong(item.stored());
            buf.writeLong(item.extracting());
            buf.writeLong(item.processing());
            buf.writeLong(item.scheduled());
            buf.writeLong(item.crafting());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void encodeSinkKey(RegistryFriendlyByteBuf buf, @Nullable ExternalPatternSinkKey sinkKey) {
            String stack;
            String name;
            if (!(sinkKey instanceof InWorldExternalPatternSinkKey)) {
                buf.writeBoolean(false);
                return;
            }
            InWorldExternalPatternSinkKey inWorldExternalPatternSinkKey = (InWorldExternalPatternSinkKey)sinkKey;
            try {
                String string;
                name = string = inWorldExternalPatternSinkKey.name();
                stack = string = inWorldExternalPatternSinkKey.stack();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            buf.writeBoolean(true);
            buf.writeUtf(name);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)stack);
        }
    }
}

