/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDiskContainerBlockEntity<T extends AbstractStorageContainerNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    protected final FilterWithFuzzyMode filter;
    protected final DiskInventory diskInventory;
    @Nullable
    protected Disk[] disks;
    private final DiskStateChangeListener diskStateListener = new DiskStateChangeListener(this);

    protected AbstractDiskContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, T node) {
        super(type, pos, state, node);
        this.diskInventory = new DiskInventory((inventory, slot) -> this.onDiskChanged(slot), ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getSize());
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), this::setChanged, this::setFilters);
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setListener(this.diskStateListener);
        this.setNormalizer(this.filter.createNormalizer());
    }

    @Override
    protected void containerInitialized() {
        super.containerInitialized();
        PlatformUtil.sendBlockUpdateToClient(this.level, this.worldPosition);
    }

    protected abstract void setFilters(Set<ResourceKey> var1);

    protected abstract void setNormalizer(UnaryOperator<ResourceKey> var1);

    @Nullable
    public static Item getDisk(CompoundTag tag, int slot, HolderLookup.Provider provider) {
        if (!tag.contains(TAG_DISK_INVENTORY)) {
            return null;
        }
        CompoundTag diskInventoryTag = tag.getCompound(TAG_DISK_INVENTORY);
        if (!ContainerUtil.hasItemInSlot(diskInventoryTag, slot)) {
            return null;
        }
        ItemStack diskStack = ContainerUtil.getItemInSlot(diskInventoryTag, slot, provider);
        return diskStack.isEmpty() ? null : diskStack.getItem();
    }

    void updateDiskStateIfNecessaryInLevel() {
        this.diskStateListener.updateIfNecessary();
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.initialize(level);
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.initialize(this.level);
        }
    }

    private void initialize(Level level) {
        this.diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository(level));
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setProvider(this.diskInventory);
    }

    @Override
    public void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        PlatformUtil.sendBlockUpdateToClient(this.level, this.worldPosition);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.fromClientTag(tag);
        if (tag.contains(TAG_DISK_INVENTORY)) {
            ContainerUtil.read(tag.getCompound(TAG_DISK_INVENTORY), (Container)this.diskInventory, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_DISK_INVENTORY, (Tag)ContainerUtil.write((Container)this.diskInventory, provider));
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public FilteredContainer getDiskInventory() {
        return this.diskInventory;
    }

    private void onDiskChanged(int slot) {
        boolean isPlacedThroughDismantlingMode;
        boolean isJustPlacedIntoLevelOrLoading = this.level == null || this.level.isClientSide();
        boolean bl = isPlacedThroughDismantlingMode = ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null;
        if (isJustPlacedIntoLevelOrLoading || isPlacedThroughDismantlingMode) {
            return;
        }
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).onStorageChanged(slot);
        PlatformUtil.sendBlockUpdateToClient(this.level, this.worldPosition);
        this.setChanged();
    }

    private void fromClientTag(CompoundTag tag) {
        if (!tag.contains(TAG_DISKS)) {
            return;
        }
        this.disks = this.diskInventory.fromSyncTag(tag.getList(TAG_DISKS, 10));
        this.onClientDriveStateUpdated();
    }

    protected void onClientDriveStateUpdated() {
        if (this.level == null) {
            return;
        }
        Platform.INSTANCE.requestModelDataUpdateOnClient((LevelAccessor)this.level, this.worldPosition, true);
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null) {
            return tag;
        }
        tag.put(TAG_DISKS, (Tag)this.diskInventory.toSyncTag(((AbstractStorageContainerNetworkNode)this.mainNetworkNode)::getState));
        return tag;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.diskInventory.getContainerSize(); ++i) {
            drops.add((Object)this.diskInventory.getItem(i));
        }
        return drops;
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

