/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record AutocraftingRequestPacket(UUID id, PlatformResourceKey resource, long amount, boolean notifyPlayer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AutocraftingRequestPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("autocrafting_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutocraftingRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, AutocraftingRequestPacket::id, ResourceCodecs.STREAM_CODEC, AutocraftingRequestPacket::resource, (StreamCodec)ByteBufCodecs.VAR_LONG, AutocraftingRequestPacket::amount, (StreamCodec)ByteBufCodecs.BOOL, AutocraftingRequestPacket::notifyPlayer, AutocraftingRequestPacket::new);

    public static void handle(AutocraftingRequestPacket packet, PacketContext ctx) {
        Player player = ctx.getPlayer();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof PreviewProvider) {
            PreviewProvider provider = (PreviewProvider)abstractContainerMenu;
            PlayerActor playerActor = new PlayerActor(player);
            provider.startTask(packet.resource, packet.amount, playerActor, packet.notifyPlayer, new TimeoutableCancellationToken()).thenAccept(taskId -> S2CPackets.sendAutocraftingResponse((ServerPlayer)player, packet.id, taskId.isPresent()));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

