/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.serialization.MapCodec;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridOperationsImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

class FluidResourceType
implements ResourceType {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("misc", "resource_type.fluid");
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("widget/side_button/resource_type/fluid");

    FluidResourceType() {
    }

    @Override
    public long normalizeAmount(double amount) {
        return (long)(amount * (double)Platform.INSTANCE.getBucketAmount());
    }

    @Override
    public double getDisplayAmount(long amount) {
        return (double)amount / (double)Platform.INSTANCE.getBucketAmount();
    }

    @Override
    public long getInterfaceExportLimit() {
        return Platform.INSTANCE.getBucketAmount() * 16L;
    }

    @Override
    public GridOperations createGridOperations(RootStorage rootStorage, Actor actor) {
        return new GridOperationsImpl(rootStorage, actor, fluidResource -> Long.MAX_VALUE, Platform.INSTANCE.getBucketAmount());
    }

    @Override
    public MapCodec<PlatformResourceKey> getMapCodec() {
        return ResourceCodecs.FLUID_MAP_CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> getStreamCodec() {
        return ResourceCodecs.FLUID_STREAM_CODEC;
    }

    @Override
    public MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    public ResourceLocation getSprite() {
        return SPRITE;
    }
}

