/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeTicker;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainerListener;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeContainer
extends SimpleContainer
implements UpgradeState {
    private static final int DEFAULT_WORK_TICK_RATE = 9;
    private static final int DEFAULT_SIZE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeContainer.class);
    private final UpgradeDestination destination;
    private final UpgradeRegistry registry;
    private final Object2IntMap<UpgradeItem> index = new Object2IntOpenHashMap();
    @Nullable
    private final UpgradeContainerListener listener;
    private final int defaultWorkTickRate;
    private final ThrottledNetworkNodeTicker ticker;

    public UpgradeContainer(UpgradeDestination destination) {
        this(destination, null);
    }

    public UpgradeContainer(UpgradeDestination destination, int size) {
        this(size, destination, null, 9);
    }

    public UpgradeContainer(UpgradeDestination destination, @Nullable UpgradeContainerListener listener) {
        this(destination, listener, 9);
    }

    public UpgradeContainer(int size, UpgradeDestination destination, @Nullable UpgradeContainerListener listener) {
        this(4, destination, listener, 9);
    }

    public UpgradeContainer(UpgradeDestination destination, @Nullable UpgradeContainerListener listener, int defaultWorkTickRate) {
        this(4, destination, listener, defaultWorkTickRate);
    }

    public UpgradeContainer(int size, UpgradeDestination destination, @Nullable UpgradeContainerListener listener, int defaultWorkTickRate) {
        super(size);
        this.destination = destination;
        this.registry = RefinedStorageApi.INSTANCE.getUpgradeRegistry();
        this.addListener(container -> this.updateIndex());
        this.addListener(container -> this.notifyListener());
        this.listener = listener;
        this.defaultWorkTickRate = defaultWorkTickRate;
        this.ticker = new ThrottledNetworkNodeTicker(defaultWorkTickRate);
    }

    public NetworkNodeTicker getTicker() {
        return this.ticker;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        UpgradeMapping upgrade = this.getAllowedUpgrades().stream().filter(u -> u.upgradeItem() == stack.getItem()).findFirst().orElse(null);
        if (upgrade == null) {
            return false;
        }
        int currentCount = this.countItem(stack.getItem());
        if (currentCount >= upgrade.maxAmount()) {
            return false;
        }
        return super.canPlaceItem(slot, stack);
    }

    public Set<UpgradeMapping> getAllowedUpgrades() {
        return this.registry.getByDestination(this.destination);
    }

    @Override
    public long getRegulatedAmount(ResourceKey resource) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            RegulatorUpgradeItem item;
            long regulatedAmount;
            ItemStack stack = this.getItem(i);
            Item item2 = stack.getItem();
            if (!(item2 instanceof RegulatorUpgradeItem) || (regulatedAmount = (item = (RegulatorUpgradeItem)item2).getDesiredAmount(stack, resource)) <= 0L) continue;
            return regulatedAmount;
        }
        return 0L;
    }

    private void updateIndex() {
        LOGGER.debug("Updating upgrade index for {}", (Object)this.destination);
        this.index.clear();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.updateIndex(i);
        }
    }

    private void updateIndex(int slotIndex) {
        ItemStack stack = this.getItem(slotIndex);
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof UpgradeItem)) {
            return;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        this.index.put((Object)upgradeItem, this.index.getInt((Object)upgradeItem) + 1);
    }

    private void notifyListener() {
        if (this.listener == null) {
            return;
        }
        LOGGER.debug("Reconfiguring for upgrades");
        int amountOfSpeedUpgrades = this.getAmount(Items.INSTANCE.getSpeedUpgrade());
        this.ticker.workTickRate = this.defaultWorkTickRate - amountOfSpeedUpgrades * 2;
        this.listener.updateState(this, this.getEnergyUsage());
    }

    @Override
    public int getAmount(UpgradeItem upgradeItem) {
        return this.index.getInt((Object)upgradeItem);
    }

    public long getEnergyUsage() {
        long usage = 0L;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            usage += upgradeItem.getEnergyUsage();
        }
        return usage;
    }

    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            upgrades.add(stack.copy());
        }
        return upgrades;
    }

    public boolean addUpgrade(ItemStack upgrade) {
        return this.addItem(upgrade).isEmpty();
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            drops.add((Object)this.getItem(i));
        }
        return drops;
    }

    private static class ThrottledNetworkNodeTicker
    implements NetworkNodeTicker {
        private int workTickRate;
        private int workTicks;

        private ThrottledNetworkNodeTicker(int workTickRate) {
            this.workTickRate = workTickRate;
        }

        @Override
        public void tick(AbstractNetworkNode networkNode) {
            if (this.workTicks++ % this.workTickRate == 0) {
                networkNode.doWork();
            }
        }
    }
}

