/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen.tag;

import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlock;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerBlock;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorBlock;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorBlock;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.content.Tags;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.exporter.ExporterBlock;
import com.refinedmods.refinedstorage.common.grid.CraftingGridBlock;
import com.refinedmods.refinedstorage.common.grid.GridBlock;
import com.refinedmods.refinedstorage.common.importer.ImporterBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.RelayBlock;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlock;
import com.refinedmods.refinedstorage.common.security.SecurityManagerBlock;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceBlock;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagsProviderImpl
extends ItemTagsProvider {
    public ItemTagsProviderImpl(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, TagsProvider<Block> blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, blockTagsProvider.contentsGetter(), "refinedstorage", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addAllToTag2(Tags.CABLES, Items.INSTANCE.getCables());
        this.addAllToTag(Tags.CONTROLLERS, Items.INSTANCE.getControllers());
        this.addAllToTag(Tags.CREATIVE_CONTROLLERS, Blocks.INSTANCE.getCreativeController().values().stream().map(Block::asItem).map(c -> () -> c).toList());
        this.addAllToTag(Tags.FLUID_STORAGE_DISKS, Arrays.stream(FluidStorageVariant.values()).filter(variant -> variant != FluidStorageVariant.CREATIVE).map(Items.INSTANCE::getFluidStorageDisk).map(t -> () -> t).toList());
        this.addAllToTag(Tags.GRIDS, Blocks.INSTANCE.getGrid().values().stream().map(block -> () -> ((GridBlock)block).asItem()).toList());
        this.addAllToTag(Tags.CRAFTING_GRIDS, Blocks.INSTANCE.getCraftingGrid().values().stream().map(block -> () -> ((CraftingGridBlock)block).asItem()).toList());
        this.addAllToTag(Tags.PATTERN_GRIDS, Blocks.INSTANCE.getPatternGrid().values().stream().map(block -> () -> ((PatternGridBlock)block).asItem()).toList());
        this.addAllToTag(Tags.STORAGE_DISKS, Arrays.stream(ItemStorageVariant.values()).filter(variant -> variant != ItemStorageVariant.CREATIVE).map(Items.INSTANCE::getItemStorageDisk).map(t -> () -> t).toList());
        this.addAllToTag(Tags.IMPORTERS, Blocks.INSTANCE.getImporter().values().stream().map(block -> () -> ((ImporterBlock)block).asItem()).toList());
        this.addAllToTag(Tags.EXPORTERS, Blocks.INSTANCE.getExporter().values().stream().map(block -> () -> ((ExporterBlock)block).asItem()).toList());
        this.addAllToTag(Tags.EXTERNAL_STORAGES, Blocks.INSTANCE.getExternalStorage().values().stream().map(block -> () -> ((ExternalStorageBlock)block).asItem()).toList());
        this.addAllToTag(Tags.DETECTORS, Blocks.INSTANCE.getDetector().values().stream().map(block -> () -> ((DetectorBlock)block).asItem()).toList());
        this.addAllToTag(Tags.CONSTRUCTORS, Blocks.INSTANCE.getConstructor().values().stream().map(block -> () -> ((ConstructorBlock)block).asItem()).toList());
        this.addAllToTag(Tags.DESTRUCTORS, Blocks.INSTANCE.getDestructor().values().stream().map(block -> () -> ((DestructorBlock)block).asItem()).toList());
        this.addAllToTag(Tags.WIRELESS_TRANSMITTERS, Blocks.INSTANCE.getWirelessTransmitter().values().stream().map(block -> () -> ((WirelessTransmitterBlock)block).asItem()).toList());
        this.addAllToTag(Tags.NETWORK_RECEIVERS, Blocks.INSTANCE.getNetworkReceiver().values().stream().map(block -> () -> ((NetworkReceiverBlock)block).asItem()).toList());
        this.addAllToTag(Tags.NETWORK_TRANSMITTERS, Blocks.INSTANCE.getNetworkTransmitter().values().stream().map(block -> () -> ((NetworkTransmitterBlock)block).asItem()).toList());
        this.addAllToTag(Tags.SECURITY_MANAGERS, Blocks.INSTANCE.getSecurityManager().values().stream().map(block -> () -> ((SecurityManagerBlock)block).asItem()).toList());
        this.addAllToTag(Tags.RELAYS, Blocks.INSTANCE.getRelay().values().stream().map(block -> () -> ((RelayBlock)block).asItem()).toList());
        this.addAllToTag(Tags.DISK_INTERFACES, Blocks.INSTANCE.getDiskInterface().values().stream().map(block -> () -> ((DiskInterfaceBlock)block).asItem()).toList());
        this.addAllToTag(Tags.AUTOCRAFTERS, Blocks.INSTANCE.getAutocrafter().values().stream().map(block -> () -> ((AutocrafterBlock)block).asItem()).toList());
        this.addAllToTag(Tags.AUTOCRAFTER_MANAGERS, Blocks.INSTANCE.getAutocrafterManager().values().stream().map(block -> () -> ((AutocrafterManagerBlock)block).asItem()).toList());
        this.addAllToTag(Tags.AUTOCRAFTING_MONITORS, Blocks.INSTANCE.getAutocraftingMonitor().values().stream().map(block -> () -> ((AutocraftingMonitorBlock)block).asItem()).toList());
    }

    private <T extends Item> void addAllToTag(TagKey<Item> t, Collection<Supplier<T>> items) {
        this.tag(t).add((Object[])((Item[])items.stream().map(Supplier::get).toArray(Item[]::new))).replace(false);
    }

    private void addAllToTag2(TagKey<Item> t, Collection<Supplier<BaseBlockItem>> items) {
        this.tag(t).add((Object[])((Item[])items.stream().map(Supplier::get).toArray(Item[]::new))).replace(false);
    }
}

