/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage.diskinterface;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.storage.diskinterface.DiskInterfaceBakedModel;
import com.refinedmods.refinedstorage.neoforge.support.render.DiskModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class DiskInterfaceUnbakedGeometry
implements IUnbakedGeometry<DiskInterfaceUnbakedGeometry> {
    private static final ResourceLocation INACTIVE_MODEL = IdentifierUtil.createIdentifier("block/disk_interface/inactive");
    private static final ResourceLocation LED_INACTIVE_MODEL = IdentifierUtil.createIdentifier("block/disk/led_inactive");
    private final ResourceLocation baseModel;

    DiskInterfaceUnbakedGeometry(DyeColor color) {
        this.baseModel = IdentifierUtil.createIdentifier("block/disk_interface/base_" + color.getName());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        modelGetter.apply(this.baseModel).resolveParents(modelGetter);
        modelGetter.apply(INACTIVE_MODEL).resolveParents(modelGetter);
        RefinedStorageClientApi.INSTANCE.getDiskModels().forEach(diskModel -> ((UnbakedModel)modelGetter.apply((ResourceLocation)diskModel)).resolveParents(modelGetter));
        modelGetter.apply(LED_INACTIVE_MODEL).resolveParents(modelGetter);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new DiskInterfaceBakedModel(Objects.requireNonNull(baker.bake(this.baseModel, modelState, spriteGetter)), new RotationTranslationModelBaker(modelState, baker, spriteGetter, INACTIVE_MODEL), new RotationTranslationModelBaker(modelState, baker, spriteGetter, this.baseModel), new DiskModelBaker(modelState, baker, spriteGetter), new RotationTranslationModelBaker(modelState, baker, spriteGetter, LED_INACTIVE_MODEL));
    }
}

