/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class ItemAffixes {
    public static final Codec<ItemAffixes> CODEC = Codec.unboundedMap((Codec)AffixRegistry.INSTANCE.holderCodec(), (Codec)Codec.floatRange((float)0.0f, (float)2.0f)).xmap(Object2FloatOpenHashMap::new, Function.identity()).xmap(ItemAffixes::new, i -> i.affixes);
    public static final StreamCodec<ByteBuf, ItemAffixes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2FloatOpenHashMap::new, (StreamCodec)AffixRegistry.INSTANCE.holderStreamCodec(), (StreamCodec)ByteBufCodecs.FLOAT), ia -> ia.affixes, ItemAffixes::new);
    public static final ItemAffixes EMPTY = new ItemAffixes((Object2FloatOpenHashMap<DynamicHolder<Affix>>)new Object2FloatOpenHashMap());
    private final Object2FloatOpenHashMap<DynamicHolder<Affix>> affixes;

    private ItemAffixes(Object2FloatOpenHashMap<DynamicHolder<Affix>> affixes) {
        this.affixes = affixes;
        for (Object2FloatMap.Entry entry : affixes.object2FloatEntrySet()) {
            float level = entry.getFloatValue();
            if (!(level < 0.0f) && !(level > 2.0f)) continue;
            throw new IllegalArgumentException("Affix " + String.valueOf(entry.getKey()) + " has invalid level " + level);
        }
    }

    public float getLevel(DynamicHolder<Affix> key) {
        return this.affixes.getFloat(key);
    }

    public boolean isEmpty() {
        return this.affixes.isEmpty();
    }

    public int size() {
        return this.affixes.size();
    }

    public ObjectSet<Object2FloatMap.Entry<DynamicHolder<Affix>>> entrySet() {
        return ObjectSets.unmodifiable((ObjectSet)this.affixes.object2FloatEntrySet());
    }

    public ObjectSet<DynamicHolder<Affix>> keySet() {
        return ObjectSets.unmodifiable((ObjectSet)this.affixes.keySet());
    }

    public Stream<Affix> liveAffixes() {
        return this.keySet().stream().filter(DynamicHolder::isBound).map(DynamicHolder::get);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ItemAffixes)) return false;
        ItemAffixes iafxs = (ItemAffixes)other;
        if (!iafxs.affixes.equals(this.affixes)) return false;
        return true;
    }

    public int hashCode() {
        return this.affixes.hashCode();
    }

    public String toString() {
        return "ItemAffixes{affixes=" + String.valueOf(this.affixes) + "}";
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        Object2FloatOpenHashMap<DynamicHolder<Affix>> affixes = new Object2FloatOpenHashMap();

        public Builder(ItemAffixes base) {
            this.affixes.putAll(base.affixes);
        }

        public Builder put(DynamicHolder<Affix> affix, float level) {
            if (level <= 0.0f) {
                this.affixes.removeFloat(affix);
            } else {
                this.affixes.put(affix, Math.clamp(level, 0.0f, 2.0f));
            }
            return this;
        }

        public Builder upgrade(DynamicHolder<Affix> affix, float level) {
            if (level > 0.0f) {
                this.affixes.merge(affix, Math.clamp(level, 0.0f, 2.0f), Float::max);
            }
            return this;
        }

        public Builder remove(DynamicHolder<Affix> affix) {
            this.affixes.removeFloat(affix);
            return this;
        }

        public Builder removeIf(Predicate<DynamicHolder<Affix>> filter) {
            this.affixes.keySet().removeIf(filter);
            return this;
        }

        public float getLevel(DynamicHolder<Affix> key) {
            return this.affixes.getFloat(key);
        }

        public boolean isEmpty() {
            return this.affixes.isEmpty();
        }

        public int size() {
            return this.affixes.size();
        }

        public ObjectSet<Object2FloatMap.Entry<DynamicHolder<Affix>>> entrySet() {
            return ObjectSets.unmodifiable((ObjectSet)this.affixes.object2FloatEntrySet());
        }

        public ObjectSet<DynamicHolder<Affix>> keySet() {
            return ObjectSets.unmodifiable((ObjectSet)this.affixes.keySet());
        }

        public ItemAffixes build() {
            return new ItemAffixes(this.affixes);
        }
    }
}

