/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.shadowsoffire.apotheosis.affix.effect.RadialAffix;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.special.RadialBonus;
import dev.shadowsoffire.apotheosis.util.RadialUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class RadialProgressTracker {
    private static final int MAX_BLOCKS = 100;
    @Nullable
    private static CacheKey lastKey = null;
    private static Set<BlockPos> knownAOEBlocks = Set.of();

    private static Set<BlockPos> getAOEBlocks() {
        ItemStack tool;
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult res = Minecraft.getInstance().hitResult;
        ItemStack itemStack = tool = player == null ? ItemStack.EMPTY : player.getMainHandItem();
        if (level == null || player == null || res == null || res.getType() != HitResult.Type.BLOCK || tool.isEmpty() || !RadialUtil.RadialState.isRadialMiningEnabled((Player)player)) {
            lastKey = null;
            knownAOEBlocks = Set.of();
            return knownAOEBlocks;
        }
        BlockHitResult blockTrace = (BlockHitResult)res;
        BlockPos pos = blockTrace.getBlockPos();
        Direction dir = blockTrace.getDirection();
        CacheKey key = new CacheKey(pos, player.getMainHandItem(), dir, player.getDirection());
        if (lastKey != null && lastKey.equals(key)) {
            return knownAOEBlocks;
        }
        lastKey = key;
        RadialUtil.RadialData afxData = RadialAffix.getRadialData(tool);
        RadialUtil.RadialData gemData = RadialBonus.getRadialData(tool);
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        if (afxData != null) {
            positions.addAll(RadialUtil.getBrokenBlocks((Player)player, dir, pos, afxData));
        }
        if (gemData != null) {
            positions.addAll(RadialUtil.getBrokenBlocks((Player)player, dir, pos, gemData));
        }
        knownAOEBlocks = positions;
        return knownAOEBlocks;
    }

    public static void breakClientBlocks(MultiPlayerGameMode mode, BlockPos srcPos) {
        if (lastKey != null && RadialProgressTracker.lastKey.pos.equals((Object)srcPos)) {
            ClientLevel level = Minecraft.getInstance().level;
            for (BlockPos pos : RadialProgressTracker.getAOEBlocks()) {
                level.removeBlock(pos, false);
            }
            lastKey = null;
            knownAOEBlocks = Set.of();
        }
    }

    @SubscribeEvent
    public static void renderBlockHighlights(RenderHighlightEvent.Block e) {
        Set<BlockPos> extraBlocks = RadialProgressTracker.getAOEBlocks();
        if (extraBlocks.isEmpty()) {
            return;
        }
        LevelRenderer levelRender = e.getLevelRenderer();
        PoseStack matrices = e.getPoseStack();
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexBuilder = buffers.getBuffer(RenderType.lines());
        matrices.pushPose();
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        Entity viewEntity = renderInfo.getEntity();
        Level level = viewEntity.level();
        Vec3 vector3d = renderInfo.getPosition();
        double x = vector3d.x();
        double y = vector3d.y();
        double z = vector3d.z();
        int rendered = 0;
        for (BlockPos pos : extraBlocks) {
            levelRender.renderHitOutline(matrices, vertexBuilder, viewEntity, x, y, z, pos, level.getBlockState(pos));
            if (rendered++ <= 100) continue;
            break;
        }
        matrices.popPose();
        buffers.endBatch();
    }

    @SubscribeEvent
    public static void renderStage(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Set<BlockPos> extraBlocks = RadialProgressTracker.getAOEBlocks();
        if (extraBlocks.isEmpty()) {
            return;
        }
        MultiPlayerGameMode controller = Minecraft.getInstance().gameMode;
        if (controller == null || !controller.isDestroying()) {
            return;
        }
        BlockPos target = RadialProgressTracker.lastKey.pos;
        BlockDestructionProgress progress = null;
        for (Int2ObjectMap.Entry entry : e.getLevelRenderer().destroyingBlocks.int2ObjectEntrySet()) {
            if (!((BlockDestructionProgress)entry.getValue()).getPos().equals((Object)target)) continue;
            progress = (BlockDestructionProgress)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockState state = level.getBlockState(target);
        if (!RadialUtil.isEffective(state, (Player)player, target)) {
            return;
        }
        PoseStack matrices = e.getPoseStack();
        matrices.pushPose();
        MultiBufferSource.BufferSource vertices = Minecraft.getInstance().renderBuffers().crumblingBufferSource();
        VertexConsumer vertexBuilder = vertices.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(progress.getProgress()));
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        double x = renderInfo.getPosition().x;
        double y = renderInfo.getPosition().y;
        double z = renderInfo.getPosition().z;
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        int rendered = 0;
        for (BlockPos pos : extraBlocks) {
            matrices.pushPose();
            matrices.translate((double)pos.getX() - x, (double)pos.getY() - y, (double)pos.getZ() - z);
            PoseStack.Pose entry = matrices.last();
            SheetedDecalTextureGenerator blockBuilder = new SheetedDecalTextureGenerator(vertexBuilder, entry, 1.0f);
            ModelData modelData = level.getModelData(pos);
            dispatcher.renderBreakingTexture(level.getBlockState(pos), pos, (BlockAndTintGetter)level, matrices, (VertexConsumer)blockBuilder, modelData);
            matrices.popPose();
            int n = ++rendered;
            ++rendered;
            if (n <= 100) continue;
            break;
        }
        matrices.popPose();
        vertices.endBatch();
    }

    private record CacheKey(BlockPos pos, HoverEvent.ItemStackInfo tool, Direction hitDir, Direction playerDir) {
        private CacheKey(BlockPos pos, ItemStack tool, Direction hitDir, Direction playerDir) {
            this(pos, new HoverEvent.ItemStackInfo(tool), hitDir, playerDir);
        }
    }
}

