/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat;

import dev.shadowsoffire.apotheosis.Apotheosis;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class GameStagesCompat {
    public static boolean hasStage(Player player, Set<String> stages) {
        return !Apotheosis.STAGES_LOADED || stages.isEmpty() || Inner.hasStage(player, stages);
    }

    public static Set<String> getStages(Player player) {
        return Apotheosis.STAGES_LOADED ? Inner.getStages(player) : Set.of();
    }

    private static class Inner {
        private Inner() {
        }

        private static boolean hasStage(Player player, Set<String> stages) {
            return false;
        }

        private static Set<String> getStages(Player player) {
            return Set.of();
        }
    }

    public static interface IStaged {
        @Nullable
        public Set<String> getStages();

        public static <T extends IStaged> Predicate<T> matches(Player player) {
            return obj -> GameStagesCompat.hasStage(player, obj.getStages());
        }
    }
}

