/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.twilight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFSounds;

public class FortificationBonus
extends GemBonus {
    public static final Codec<FortificationBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(FortificationBonus.gemClass(), (App)Purity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, FortificationBonus::new));
    protected final Map<Purity, Data> values;

    public FortificationBonus(GemClass gemClass, Map<Purity, Data> values) {
        super(gemClass);
        this.values = values;
    }

    @Override
    public void doPostHurt(GemInstance inst, LivingEntity user, DamageSource source) {
        Data d = this.values.get(inst.purity());
        if (Affix.isOnCooldown(FortificationBonus.makeUniqueId(inst), d.cooldown, user)) {
            return;
        }
        if (user.hasData((Supplier)TFDataAttachments.FORTIFICATION_SHIELDS) && user.getRandom().nextFloat() <= d.chance) {
            ((FortificationShieldAttachment)user.getData((Supplier)TFDataAttachments.FORTIFICATION_SHIELDS)).setShields(user, 5, true);
            user.playSound((SoundEvent)TFSounds.SHIELD_ADD.get(), 1.0f, (user.getRandom().nextFloat() - user.getRandom().nextFloat()) * 0.2f + 1.0f);
            Affix.startCooldown(FortificationBonus.makeUniqueId(inst), user);
        }
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        Data d = this.values.get(inst.purity());
        MutableComponent cooldown = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)d.cooldown, (float)ctx.tickRate())});
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(d.chance * 100.0f), cooldown}).withStyle(ChatFormatting.YELLOW);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected record Data(float chance, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(Data::chance), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }

    public static class Builder
    extends GemBonus.Builder {
        protected final Map<Purity, Data> values = new HashMap<Purity, Data>();

        public Builder value(Purity purity, float chance, int cooldown) {
            this.values.put(purity, new Data(chance, cooldown));
            return this;
        }

        @Override
        public FortificationBonus build(GemClass gClass) {
            return new FortificationBonus(gClass, this.values);
        }
    }
}

