/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;

public record RarityRenderData(float beamHeight, float beamRadius, ResourceLocation beamTexture, float glowRadius, ResourceLocation glowTexture, ShadowData shadow, ParticleData particle) {
    public static final RarityRenderData DEFAULT = new RarityRenderData(3.5f, 0.035f, Apotheosis.loc("textures/rarity/beam.png"), 0.065f, Apotheosis.loc("textures/rarity/glow.png"), ShadowData.DEFAULT, ParticleData.DEFAULT);
    public static final Codec<RarityRenderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)256.0f).fieldOf("beam_height").forGetter(RarityRenderData::beamHeight), (App)Codec.floatRange((float)0.0f, (float)5.0f).fieldOf("beam_radius").forGetter(RarityRenderData::beamRadius), (App)ResourceLocation.CODEC.fieldOf("beam_texture").forGetter(RarityRenderData::beamTexture), (App)Codec.floatRange((float)0.0f, (float)7.0f).fieldOf("glow_radius").forGetter(RarityRenderData::glowRadius), (App)ResourceLocation.CODEC.fieldOf("glow_texture").forGetter(RarityRenderData::glowTexture), (App)ShadowData.CODEC.optionalFieldOf("shadow", (Object)ShadowData.DEFAULT).forGetter(RarityRenderData::shadow), (App)ParticleData.CODEC.optionalFieldOf("particle", (Object)ParticleData.DEFAULT).forGetter(RarityRenderData::particle)).apply((Applicative)instance, RarityRenderData::new));

    public record ShadowData(float size, int alpha, ResourceLocation texture, int frames, float frameTime) {
        public static final ShadowData DEFAULT = new ShadowData(0.35f, 255, Apotheosis.loc("textures/rarity/shadow.png"), 1, 1.0f);
        public static final Codec<ShadowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)2.0f).fieldOf("size").forGetter(ShadowData::size), (App)Codec.intRange((int)0, (int)255).fieldOf("alpha").forGetter(ShadowData::alpha), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(ShadowData::texture), (App)Codec.intRange((int)1, (int)128).fieldOf("frames").orElse((Object)1).forGetter(ShadowData::frames), (App)Codec.floatRange((float)0.5f, (float)40.0f).fieldOf("frame_time").orElse((Object)Float.valueOf(1.0f)).forGetter(ShadowData::frameTime)).apply((Applicative)instance, ShadowData::new));

        public static class Builder {
            private int alpha;
            private float size;
            private ResourceLocation texture;
            private int frames;
            private float frameTime;

            public Builder() {
                this.alpha = ShadowData.DEFAULT.alpha;
                this.size = ShadowData.DEFAULT.size;
                this.texture = ShadowData.DEFAULT.texture;
                this.frames = ShadowData.DEFAULT.frames;
                this.frameTime = ShadowData.DEFAULT.frameTime;
            }

            public Builder size(float size) {
                this.size = size;
                return this;
            }

            public Builder alpha(int alpha) {
                this.alpha = alpha;
                return this;
            }

            public Builder texture(ResourceLocation texture) {
                this.texture = texture;
                return this;
            }

            public Builder frames(int frames) {
                this.frames = frames;
                return this;
            }

            public Builder frameTime(float frameTime) {
                this.frameTime = frameTime;
                return this;
            }

            public ShadowData build() {
                return new ShadowData(this.size, this.alpha, this.texture, this.frames, this.frameTime);
            }
        }
    }

    public record ParticleData(boolean enabled) {
        public static final ParticleData DEFAULT = new ParticleData(false);
        public static final Codec<ParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(ParticleData::enabled)).apply((Applicative)instance, ParticleData::new));
    }

    public static class Builder {
        private float beamRadius;
        private float beamHeight;
        private ResourceLocation beamTexture;
        private float glowRadius;
        private ResourceLocation glowTexture;
        private ShadowData shadow;
        private boolean hasParticles;

        public Builder() {
            this.beamRadius = RarityRenderData.DEFAULT.beamRadius;
            this.beamHeight = RarityRenderData.DEFAULT.beamHeight;
            this.beamTexture = RarityRenderData.DEFAULT.beamTexture;
            this.glowRadius = RarityRenderData.DEFAULT.glowRadius;
            this.glowTexture = RarityRenderData.DEFAULT.glowTexture;
            this.shadow = RarityRenderData.DEFAULT.shadow;
            this.hasParticles = RarityRenderData.DEFAULT.particle.enabled;
        }

        public Builder beamHeight(float height) {
            this.beamHeight = height;
            return this;
        }

        public Builder beamRadius(float radius) {
            this.beamRadius = radius;
            return this;
        }

        public Builder beamTexture(ResourceLocation texture) {
            this.beamTexture = texture;
            return this;
        }

        public Builder glowRadius(float radius) {
            this.glowRadius = radius;
            return this;
        }

        public Builder glowTexture(ResourceLocation texture) {
            this.glowTexture = texture;
            return this;
        }

        public Builder shadow(UnaryOperator<ShadowData.Builder> config) {
            this.shadow = ((ShadowData.Builder)config.apply(new ShadowData.Builder())).build();
            return this;
        }

        public Builder particle(boolean particle) {
            this.hasParticles = particle;
            return this;
        }

        public RarityRenderData build() {
            return new RarityRenderData(this.beamHeight, this.beamRadius, this.beamTexture, this.glowRadius, this.glowTexture, this.shadow, new ParticleData(this.hasParticles));
        }
    }
}

