/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.InvaderSpawnRules;
import dev.shadowsoffire.apotheosis.mobs.registries.AugmentRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Augmentation;
import dev.shadowsoffire.apotheosis.mobs.types.Elite;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.SpawnCooldownSavedData;
import dev.shadowsoffire.apotheosis.mobs.util.SurfaceType;
import dev.shadowsoffire.apotheosis.net.BossSpawnPayload;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ApothMobEvents {
    public static final String APOTH_MINIBOSS = "apoth.miniboss";
    public static final String APOTH_MINIBOSS_PLAYER = "apoth.miniboss.player";
    protected SpawnCooldownSavedData cooldownData = new SpawnCooldownSavedData();
    private static final Marker MARKER = MarkerManager.getMarker((String)ApothMobEvents.class.getSimpleName());

    @SubscribeEvent(priority=EventPriority.LOW)
    public void finalizeMobSpawns(FinalizeSpawnEvent e) {
        RandomSource rand;
        GenContext ctx;
        ApothMobEvents.debugLog("Finalizing spawn for: {}", e.getEntity().getName().getString());
        if (e.isCanceled() || e.isSpawnCancelled()) {
            ApothMobEvents.debugLog("Discarding due to cancellation.", new Object[0]);
            return;
        }
        Player player = e.getLevel().getNearestPlayer(e.getX(), e.getY(), e.getZ(), -1.0, false);
        if (player == null) {
            ApothMobEvents.debugLog("Discarding due to lack of player context.", new Object[0]);
            return;
        }
        Mob mob = e.getEntity();
        if (this.trySpawnInvader(e, mob, ctx = GenContext.forPlayerAtPos(rand = e.getLevel().getRandom(), player, mob.blockPosition()), player)) {
            ApothMobEvents.debugLog("Successfully spawned an invader. Skipping Augmentations and Elites.", new Object[0]);
            return;
        }
        this.tryAugmentations(e.getLevel(), mob, e.getSpawnType(), ctx);
        if (this.trySpawnElite(e, mob, ctx, player)) {
            return;
        }
    }

    private boolean trySpawnInvader(FinalizeSpawnEvent e, Mob mob, GenContext ctx, Player player) {
        if (e.getSpawnType() != MobSpawnType.NATURAL && e.getSpawnType() != MobSpawnType.CHUNK_GENERATION || !(mob instanceof Monster)) {
            ApothMobEvents.debugLog("[Invaders]: Failed invader preconditions.", new Object[0]);
            return false;
        }
        if (this.cooldownData.isOnCooldown(mob.level())) {
            ApothMobEvents.debugLog("[Invaders]: Cooldown is active for " + String.valueOf(mob.level().dimension().location()), new Object[0]);
            return false;
        }
        ServerLevelAccessor sLevel = e.getLevel();
        ResourceKey dimId = sLevel.getLevel().dimensionTypeRegistration().getKey();
        InvaderSpawnRules rules = (InvaderSpawnRules)sLevel.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getData(Apoth.DataMaps.INVADER_SPAWN_RULES, dimId);
        if (rules == null) {
            ApothMobEvents.debugLog("[Invaders]: No invader spawn rules present for dimension {}", dimId);
            return false;
        }
        float chance = rules.spawnChances().get((Object)ctx.tier()).floatValue();
        SurfaceType surface = rules.surfaceType();
        if (ctx.rand().nextFloat() > chance) {
            ApothMobEvents.debugLog("[Invaders]: Failed random chance roll.", new Object[0]);
            return false;
        }
        if (surface.test(sLevel, BlockPos.containing((double)e.getX(), (double)e.getY(), (double)e.getZ()))) {
            ApothMobEvents.debugLog("[Invaders]: Succeeded at random chance roll and surface test.", new Object[0]);
            Invader item = InvaderRegistry.INSTANCE.getRandomItem(ctx);
            if (item == null) {
                Apotheosis.LOGGER.error("Attempted to spawn an Invader in dimension {} using configured spawn rules {} but no bosses were made available.", (Object)dimId, (Object)rules);
                return false;
            }
            if (!item.basicData().canSpawn(mob, sLevel, e.getSpawnType())) {
                ApothMobEvents.debugLog("[Invaders]: Failed invader spawn conditions.", new Object[0]);
                return false;
            }
            Mob boss = item.createBoss(sLevel, BlockPos.containing((double)(e.getX() - 0.5), (double)e.getY(), (double)(e.getZ() - 0.5)), ctx);
            if (AdventureConfig.bossAutoAggro && !player.isCreative()) {
                boss.setTarget((LivingEntity)player);
            }
            if (ApothMobEvents.canSpawn((LevelAccessor)sLevel, boss, player.distanceToSqr((Entity)boss))) {
                sLevel.addFreshEntityWithPassengers((Entity)boss);
                e.setCanceled(true);
                e.setSpawnCancelled(true);
                Component name = ApothMobEvents.getName(boss);
                if (name == null || name.getStyle().getColor() == null) {
                    Apotheosis.LOGGER.warn("A Boss {} ({}) has spawned without a custom name!", (Object)boss.getName().getString(), (Object)EntityType.getKey((EntityType)boss.getType()));
                } else {
                    sLevel.players().forEach(p -> {
                        Vec3 tPos = new Vec3(boss.getX(), p.getY(), boss.getZ());
                        if (p.distanceToSqr(tPos) <= (double)(AdventureConfig.bossAnnounceRange * AdventureConfig.bossAnnounceRange)) {
                            ((ServerPlayer)p).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"info.apotheosis.boss_spawn", (Object[])new Object[]{name, (int)boss.getX(), (int)boss.getY()})));
                            TextColor color = name.getStyle().getColor();
                            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new BossSpawnPayload(boss.blockPosition(), color == null ? 0xFFFFFF : color.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    });
                }
                this.cooldownData.startCooldown(mob.level(), (int)rules.cooldown().orElse(AdventureConfig.bossSpawnCooldown));
                ApothMobEvents.debugLog("[Invaders]: Successfully spawned an invader {} at {}", name, boss.blockPosition());
                return true;
            }
            ApothMobEvents.debugLog("Failed entity spawn checks.", new Object[0]);
        } else {
            ApothMobEvents.debugLog("[Invaders]: Failed surface test " + String.valueOf(surface), new Object[0]);
        }
        return false;
    }

    private void tryAugmentations(ServerLevelAccessor level, Mob mob, MobSpawnType type, GenContext ctx) {
        float healthPct = mob.getHealth() / mob.getMaxHealth();
        for (TierAugment tierAugment : TierAugmentRegistry.getAugments(ctx.tier(), TierAugment.Target.MONSTERS)) {
            tierAugment.apply(level, (LivingEntity)mob);
        }
        mob.setData(Apoth.Attachments.TIER_AUGMENTS_APPLIED, (Object)true);
        for (Augmentation augmentation : AugmentRegistry.getAll()) {
            if (augmentation.canApply(level, mob, type, ctx)) {
                if (ctx.rand().nextFloat() <= augmentation.chance()) {
                    ApothMobEvents.debugLog("Applying augmentation {}", AugmentRegistry.INSTANCE.getKey(augmentation));
                    augmentation.apply(mob, ctx);
                    continue;
                }
                ApothMobEvents.debugLog("Roll failed for augmentation {}", AugmentRegistry.INSTANCE.getKey(augmentation));
                continue;
            }
            ApothMobEvents.debugLog("Skipped augmentation {}", AugmentRegistry.INSTANCE.getKey(augmentation));
        }
        mob.setHealth(healthPct * mob.getMaxHealth());
    }

    private boolean trySpawnElite(FinalizeSpawnEvent e, Mob mob, GenContext ctx, Player player) {
        ServerLevelAccessor sLevel = e.getLevel();
        Elite item = EliteRegistry.INSTANCE.getRandomItem(ctx, (Entity)mob);
        if (item == null) {
            ApothMobEvents.debugLog("No Elites were available for {} and {}", ctx, mob);
            return false;
        }
        if (!item.basicData().canSpawn(mob, sLevel, e.getSpawnType())) {
            ApothMobEvents.debugLog("The elite {} was selected but could not spawn based on spawn conditions.", EliteRegistry.INSTANCE.getKey(item));
            return false;
        }
        if (ctx.rand().nextFloat() <= item.getChance()) {
            mob.getPersistentData().putString(APOTH_MINIBOSS, EliteRegistry.INSTANCE.getKey(item).toString());
            mob.getPersistentData().putString(APOTH_MINIBOSS_PLAYER, player.getUUID().toString());
            if (!item.basicData().finalizeSpawn()) {
                e.setCanceled(true);
            }
            ApothMobEvents.debugLog("Successfully spawned the elite {} at {}", EliteRegistry.INSTANCE.getKey(item), mob.blockPosition());
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void delayedEliteMobs(EntityJoinLevelEvent e) {
        Mob mob;
        CompoundTag data;
        Entity entity;
        if (!e.getLevel().isClientSide && (entity = e.getEntity()) instanceof Mob && (data = (mob = (Mob)entity).getPersistentData()).contains(APOTH_MINIBOSS) && data.contains(APOTH_MINIBOSS_PLAYER)) {
            String key = data.getString(APOTH_MINIBOSS);
            try {
                UUID playerId = UUID.fromString(data.getString(APOTH_MINIBOSS_PLAYER));
                Player player = e.getLevel().getPlayerByUUID(playerId);
                if (player == null) {
                    player = e.getLevel().getNearestPlayer((Entity)mob, -1.0);
                }
                if (player != null) {
                    GenContext ctx = GenContext.forPlayerAtPos(e.getLevel().random, player, mob.blockPosition());
                    Elite item = (Elite)EliteRegistry.INSTANCE.getValue(ResourceLocation.tryParse((String)key));
                    if (item != null) {
                        item.transformMiniboss((ServerLevelAccessor)((ServerLevel)e.getLevel()), mob, ctx);
                    }
                }
            }
            catch (Exception ex) {
                Apotheosis.LOGGER.error("Failure while initializing the Apothic Elite " + key, (Throwable)ex);
            }
        }
    }

    @SubscribeEvent
    public void tick(LevelTickEvent.Post e) {
        this.cooldownData.tick(e.getLevel().dimension().location());
    }

    @SubscribeEvent
    public void load(ServerStartedEvent e) {
        this.cooldownData = (SpawnCooldownSavedData)e.getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(SpawnCooldownSavedData::new, SpawnCooldownSavedData::loadTimes, null), "apotheosis_boss_times");
    }

    private static boolean canSpawn(LevelAccessor world, Mob entity, double playerDist) {
        if (playerDist > (double)(entity.getType().getCategory().getDespawnDistance() * entity.getType().getCategory().getDespawnDistance()) && entity.removeWhenFarAway(playerDist)) {
            return false;
        }
        return entity.checkSpawnRules(world, MobSpawnType.NATURAL) && entity.checkSpawnObstruction((LevelReader)world);
    }

    @Nullable
    private static Component getName(Mob boss) {
        return boss.getSelfAndPassengers().filter(e -> e.getPersistentData().contains("apoth.boss")).findFirst().map(Entity::getCustomName).orElse(null);
    }

    private static void debugLog(String msg, Object ... args) {
        if (Apotheosis.DEBUG_MOBS) {
            Apotheosis.LOGGER.debug(MARKER, msg, args);
        }
    }
}

