/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.socket.ReactiveSmithingRecipe;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.util.ApothSmithingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WithdrawalRecipe
extends ApothSmithingRecipe
implements ReactiveSmithingRecipe {
    public WithdrawalRecipe() {
        super(Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Apoth.Items.SIGIL_OF_WITHDRAWAL.value()}), ItemStack.EMPTY);
    }

    public boolean matches(SmithingRecipeInput inv, Level level) {
        ItemStack base = inv.getItem(1);
        ItemStack sigils = inv.getItem(2);
        return base.getCount() == 1 && sigils.is(Apoth.Items.SIGIL_OF_WITHDRAWAL) && SocketHelper.getGems(base).stream().anyMatch(GemInstance::isValid);
    }

    public ItemStack assemble(SmithingRecipeInput inv, HolderLookup.Provider regs) {
        ItemStack out = inv.getItem(1).copy();
        if (out.isEmpty()) {
            return ItemStack.EMPTY;
        }
        SocketHelper.setGems(out, SocketedGems.EMPTY);
        return out;
    }

    @Override
    public void onCraft(Container inv, Player player, ItemStack output) {
        ItemStack base = inv.getItem(1);
        SocketedGems gems = SocketHelper.getGems(base);
        for (GemInstance gem : gems) {
            ItemStack stack = gem.gemStack();
            if (stack.isEmpty() || player.addItem(stack)) continue;
            Block.popResource((Level)player.level(), (BlockPos)player.blockPosition(), (ItemStack)stack);
        }
        SocketHelper.setGems(base, SocketedGems.EMPTY);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Apoth.RecipeSerializers.WITHDRAWAL.value();
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean isSpecial() {
        return true;
    }
}

