/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.cutting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.UnsocketedGem;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record PurityUpgradeRecipe(Purity purity, List<SizedIngredient> left, List<SizedIngredient> right) implements GemCuttingRecipe
{
    public static MapCodec<PurityUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Purity.CODEC.fieldOf("purity").forGetter(PurityUpgradeRecipe::purity), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("left").forGetter(PurityUpgradeRecipe::left), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("right").forGetter(PurityUpgradeRecipe::right)).apply((Applicative)inst, PurityUpgradeRecipe::new));
    public static StreamCodec<RegistryFriendlyByteBuf, PurityUpgradeRecipe> STREAM_CODEC = StreamCodec.composite(Purity.STREAM_CODEC, PurityUpgradeRecipe::purity, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), PurityUpgradeRecipe::left, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), PurityUpgradeRecipe::right, PurityUpgradeRecipe::new);

    public ItemStack assemble(GemCuttingRecipe.CuttingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack out = input.getBase().copy();
        GemItem.setPurity(out, GemItem.getPurity(out).next());
        return out;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public void decrementInputs(GemCuttingRecipe.CuttingRecipeInput input, Level level) {
        SizedIngredient left = GemCuttingRecipe.getMatchOrThrow(input.getLeft(), this.left);
        SizedIngredient right = GemCuttingRecipe.getMatchOrThrow(input.getRight(), this.right);
        input.getTop().shrink(1);
        input.getLeft().shrink(left.count());
        input.getRight().shrink(right.count());
    }

    public boolean matches(GemCuttingRecipe.CuttingRecipeInput input, Level level) {
        UnsocketedGem baseInst = UnsocketedGem.of(input.getBase());
        UnsocketedGem topInst = UnsocketedGem.of(input.getTop());
        if (baseInst.purity() != this.purity || !baseInst.equals(topInst)) {
            return false;
        }
        return GemCuttingRecipe.anyMatch(input.getLeft(), this.left) && GemCuttingRecipe.anyMatch(input.getRight(), this.right);
    }

    @Override
    public boolean isValidBaseItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        UnsocketedGem inst = UnsocketedGem.of(stack);
        return inst.isValid() && !inst.isPerfect();
    }

    @Override
    public boolean isValidTopItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        UnsocketedGem baseInst = UnsocketedGem.of(input.getBase());
        if (!baseInst.isValid() || baseInst.isPerfect()) {
            return false;
        }
        UnsocketedGem inst = UnsocketedGem.of(stack);
        return baseInst.equals(inst);
    }

    @Override
    public boolean isValidLeftItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return this.left.stream().map(SizedIngredient::ingredient).anyMatch(i -> i.test(stack));
    }

    @Override
    public boolean isValidRightItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return this.right.stream().map(SizedIngredient::ingredient).anyMatch(i -> i.test(stack));
    }

    public static class Serializer
    implements RecipeSerializer<PurityUpgradeRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<PurityUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PurityUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

