/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.net.RadialStatePayload;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class RadialUtil {
    private static ThreadLocal<Set<UUID>> breakers = ThreadLocal.withInitial(HashSet::new);

    public static void toggleRadialState(Player player) {
        RadialState state = RadialState.getState(player);
        RadialState next = state.next();
        RadialState.setState(player, next);
        player.sendSystemMessage((Component)Apotheosis.sysMessageHeader().append((Component)Apotheosis.lang("misc", "radial_state_updated", next.toComponent(), state.toComponent()).withStyle(ChatFormatting.YELLOW)));
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RadialStatePayload(next), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void attemptRadialMining(BlockEvent.BreakEvent e, RadialData data) {
        Player player = e.getPlayer();
        if (RadialState.isRadialMiningEnabled(player)) {
            RadialUtil.breakExtraBlocks(player, e.getPos(), data);
        }
    }

    public static void breakExtraBlocks(Player player, BlockPos pos, RadialData data) {
        if (!breakers.get().add(player.getUUID())) {
            return;
        }
        try {
            RadialUtil.breakBlockRadius(player, pos, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        breakers.get().remove(player.getUUID());
    }

    public static List<BlockPos> getBrokenBlocks(Player player, Direction direction, BlockPos srcPos, RadialData data) {
        Level level = player.level();
        if (data.x < 2 && data.y < 2) {
            return List.of();
        }
        int lowerY = (int)Math.ceil((double)(-data.y) / 2.0);
        int upperY = (int)Math.round((double)data.y / 2.0);
        int lowerX = (int)Math.ceil((double)(-data.x) / 2.0);
        int upperX = (int)Math.round((double)data.x / 2.0);
        ArrayList<BlockPos> broken = new ArrayList<BlockPos>();
        float srcDestroySpeed = level.getBlockState(srcPos).getDestroySpeed((BlockGetter)level, srcPos);
        for (int iy = lowerY; iy < upperY; ++iy) {
            for (int ix = lowerX; ix < upperX; ++ix) {
                BlockPos genPos = new BlockPos(srcPos.getX() + ix + data.xOff, srcPos.getY() + iy + data.yOff, srcPos.getZ());
                if (player.getDirection().getAxis() == Direction.Axis.X) {
                    genPos = new BlockPos(genPos.getX() - (ix + data.xOff), genPos.getY(), genPos.getZ() + ix + data.xOff);
                }
                if (direction.getAxis().isVertical()) {
                    genPos = RadialUtil.rotateDown(genPos, iy + data.yOff, player.getDirection());
                }
                if (genPos.equals((Object)srcPos)) continue;
                BlockState state = level.getBlockState(genPos);
                float stateDestroySpeed = state.getDestroySpeed((BlockGetter)level, genPos);
                if (state.isAir() || stateDestroySpeed == -1.0f || !(stateDestroySpeed <= srcDestroySpeed * 3.0f) || !RadialUtil.isEffective(state, player, genPos)) continue;
                broken.add(genPos);
            }
        }
        return broken;
    }

    public static HitResult tracePlayerLook(Player player) {
        Vec3 base = player.getEyePosition(0.0f);
        Vec3 look = player.getLookAngle();
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 target = base.add(look.x * reach, look.y * reach, look.z * reach);
        Level level = player.level();
        return level.clip(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static void breakBlockRadius(Player player, BlockPos srcPos, RadialData data) {
        HitResult trace = RadialUtil.tracePlayerLook(player);
        if (trace == null || trace.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult res = (BlockHitResult)trace;
        Direction face = res.getDirection();
        List<BlockPos> broken = RadialUtil.getBrokenBlocks(player, face, srcPos, data);
        for (BlockPos pos : broken) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.gameMode.destroyBlock(pos);
                continue;
            }
            ClientAccess.breakClientBlock(pos);
        }
    }

    static BlockPos rotateDown(BlockPos pos, int y, Direction horizontal) {
        Vec3i vec = horizontal.getNormal();
        return new BlockPos(pos.getX() + vec.getX() * y, pos.getY() - y, pos.getZ() + vec.getZ() * y);
    }

    public static boolean isEffective(BlockState state, Player player, BlockPos pos) {
        return player.hasCorrectToolForDrops(state, player.level(), pos);
    }

    public static enum RadialState {
        REQUIRE_NOT_SNEAKING((Predicate<Player>)((Predicate)p -> !p.isShiftKeyDown())),
        REQUIRE_SNEAKING((Predicate<Player>)((Predicate)Entity::isShiftKeyDown)),
        ENABLED((Predicate<Player>)((Predicate)p -> true)),
        DISABLED((Predicate<Player>)((Predicate)p -> false));

        public static final IntFunction<RadialState> BY_ID;
        public static final Codec<RadialState> CODEC;
        public static final StreamCodec<ByteBuf, RadialState> STREAM_CODEC;
        private Predicate<Player> condition;

        private RadialState(Predicate<Player> condition) {
            this.condition = condition;
        }

        public static boolean isRadialMiningEnabled(Player input) {
            return RadialState.getState((Player)input).condition.apply((Object)input);
        }

        public RadialState next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> REQUIRE_SNEAKING;
                case 1 -> ENABLED;
                case 2 -> DISABLED;
                case 3 -> REQUIRE_NOT_SNEAKING;
            };
        }

        public Component toComponent() {
            return Component.translatable((String)("misc.apotheosis.radial_state." + this.name().toLowerCase(Locale.ROOT)));
        }

        public static RadialState getState(Player player) {
            return (RadialState)((Object)player.getData(Apoth.Attachments.RADIAL_MINING_MODE));
        }

        public static void setState(Player player, RadialState state) {
            player.setData(Apoth.Attachments.RADIAL_MINING_MODE, (Object)state);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RadialState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = PlaceboCodecs.enumCodec(RadialState.class);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public record RadialData(int x, int y, int xOff, int yOff) {
        public static Codec<RadialData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(RadialData::x), (App)Codec.INT.fieldOf("y").forGetter(RadialData::y), (App)Codec.INT.fieldOf("xOff").forGetter(RadialData::xOff), (App)Codec.INT.fieldOf("yOff").forGetter(RadialData::yOff)).apply((Applicative)inst, RadialData::new));
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        public static void breakClientBlock(BlockPos pos) {
            Minecraft.getInstance().gameMode.destroyBlock(pos);
        }
    }
}

