/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.client;

import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpHost;
import dev.chasem.apache.http.HttpRequest;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.client.ClientProtocolException;
import dev.chasem.apache.http.client.config.RequestConfig;
import dev.chasem.apache.http.client.methods.CloseableHttpResponse;
import dev.chasem.apache.http.client.methods.Configurable;
import dev.chasem.apache.http.client.methods.HttpExecutionAware;
import dev.chasem.apache.http.client.methods.HttpRequestWrapper;
import dev.chasem.apache.http.client.protocol.HttpClientContext;
import dev.chasem.apache.http.conn.ClientConnectionManager;
import dev.chasem.apache.http.conn.ClientConnectionRequest;
import dev.chasem.apache.http.conn.HttpClientConnectionManager;
import dev.chasem.apache.http.conn.ManagedClientConnection;
import dev.chasem.apache.http.conn.routing.HttpRoute;
import dev.chasem.apache.http.conn.scheme.SchemeRegistry;
import dev.chasem.apache.http.impl.DefaultConnectionReuseStrategy;
import dev.chasem.apache.http.impl.client.CloseableHttpClient;
import dev.chasem.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import dev.chasem.apache.http.impl.execchain.MinimalClientExec;
import dev.chasem.apache.http.params.BasicHttpParams;
import dev.chasem.apache.http.params.HttpParams;
import dev.chasem.apache.http.protocol.BasicHttpContext;
import dev.chasem.apache.http.protocol.HttpContext;
import dev.chasem.apache.http.protocol.HttpRequestExecutor;
import dev.chasem.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

