/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.cookie;

import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.cookie.CommonCookieAttributeHandler;
import dev.chasem.apache.http.cookie.Cookie;
import dev.chasem.apache.http.cookie.CookieOrigin;
import dev.chasem.apache.http.cookie.CookieRestrictionViolationException;
import dev.chasem.apache.http.cookie.MalformedCookieException;
import dev.chasem.apache.http.cookie.SetCookie;
import dev.chasem.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import dev.chasem.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

