/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.entity;

import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpMessage;
import dev.chasem.apache.http.ProtocolException;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.entity.ContentLengthStrategy;
import dev.chasem.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

