/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.entity;

import dev.chasem.apache.http.Header;
import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpMessage;
import dev.chasem.apache.http.HttpVersion;
import dev.chasem.apache.http.ProtocolException;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.entity.ContentLengthStrategy;
import dev.chasem.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            String s = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(s)) {
                if (message.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + message.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(s)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + s);
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                if (len < 0L) {
                    throw new ProtocolException("Negative content length: " + s);
                }
                return len;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid content length: " + s);
            }
        }
        return this.implicitLen;
    }
}

