/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.io;

import dev.chasem.apache.http.ConnectionClosedException;
import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpRequest;
import dev.chasem.apache.http.HttpRequestFactory;
import dev.chasem.apache.http.ParseException;
import dev.chasem.apache.http.RequestLine;
import dev.chasem.apache.http.config.MessageConstraints;
import dev.chasem.apache.http.impl.DefaultHttpRequestFactory;
import dev.chasem.apache.http.impl.io.AbstractMessageParser;
import dev.chasem.apache.http.io.SessionInputBuffer;
import dev.chasem.apache.http.message.LineParser;
import dev.chasem.apache.http.message.ParserCursor;
import dev.chasem.apache.http.params.HttpParams;
import dev.chasem.apache.http.util.Args;
import dev.chasem.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int readLen = sessionBuffer.readLine(this.lineBuf);
        if (readLen == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

