/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.io;

import dev.chasem.apache.http.HttpRequest;
import dev.chasem.apache.http.HttpRequestFactory;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.config.MessageConstraints;
import dev.chasem.apache.http.impl.DefaultHttpRequestFactory;
import dev.chasem.apache.http.impl.io.DefaultHttpRequestParser;
import dev.chasem.apache.http.io.HttpMessageParser;
import dev.chasem.apache.http.io.HttpMessageParserFactory;
import dev.chasem.apache.http.io.SessionInputBuffer;
import dev.chasem.apache.http.message.BasicLineParser;
import dev.chasem.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

