/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.protocol;

import dev.chasem.apache.http.HttpEntityEnclosingRequest;
import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpRequest;
import dev.chasem.apache.http.HttpRequestInterceptor;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.protocol.HttpContext;
import dev.chasem.apache.http.protocol.HttpDateGenerator;
import dev.chasem.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

