/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.protocol;

import dev.chasem.apache.http.HttpException;
import dev.chasem.apache.http.HttpResponse;
import dev.chasem.apache.http.HttpResponseInterceptor;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.protocol.HttpContext;
import dev.chasem.apache.http.protocol.HttpDateGenerator;
import dev.chasem.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

