/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras;

import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import dev.chasem.cobblemonextras.commands.Battle;
import dev.chasem.cobblemonextras.commands.BattleSpectate;
import dev.chasem.cobblemonextras.commands.CompDelete;
import dev.chasem.cobblemonextras.commands.CompSee;
import dev.chasem.cobblemonextras.commands.EmptyBox;
import dev.chasem.cobblemonextras.commands.GivePokeToken;
import dev.chasem.cobblemonextras.commands.GiveShinyBall;
import dev.chasem.cobblemonextras.commands.ItemShout;
import dev.chasem.cobblemonextras.commands.PokeBattle;
import dev.chasem.cobblemonextras.commands.PokeDelete;
import dev.chasem.cobblemonextras.commands.PokeIVs;
import dev.chasem.cobblemonextras.commands.PokeKill;
import dev.chasem.cobblemonextras.commands.PokeOdds;
import dev.chasem.cobblemonextras.commands.PokeSee;
import dev.chasem.cobblemonextras.commands.PokeShout;
import dev.chasem.cobblemonextras.commands.PokeShoutAll;
import dev.chasem.cobblemonextras.commands.PokeTrade;
import dev.chasem.cobblemonextras.commands.Showcase;
import dev.chasem.cobblemonextras.config.CobblemonExtrasConfig;
import dev.chasem.cobblemonextras.events.CobblemonExtrasEventHandler;
import dev.chasem.cobblemonextras.events.PokeTokensInteractionHandler;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import dev.chasem.cobblemonextras.services.ShowcaseService;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u001b\u0010\u0015\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\t\"\u0004\b+\u0010,R\"\u0010.\u001a\u00020-8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Ldev/chasem/cobblemonextras/CobblemonExtras;", "", "<init>", "()V", "", "initialize", "onShutdown", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "loadConfig", "Lcom/google/gson/JsonObject;", "defaultConfig", "fileConfig", "Lcom/google/gson/JsonElement;", "mergeConfigs", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonElement;", "saveConfig", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "registerCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Ldev/chasem/cobblemonextras/permissions/CobblemonExtrasPermissions;", "permissions", "Ldev/chasem/cobblemonextras/permissions/CobblemonExtrasPermissions;", "getPermissions", "()Ldev/chasem/cobblemonextras/permissions/CobblemonExtrasPermissions;", "setPermissions", "(Ldev/chasem/cobblemonextras/permissions/CobblemonExtrasPermissions;)V", "", "MODID", "Ljava/lang/String;", "Ldev/chasem/cobblemonextras/config/CobblemonExtrasConfig;", "config", "Ldev/chasem/cobblemonextras/config/CobblemonExtrasConfig;", "getConfig", "()Ldev/chasem/cobblemonextras/config/CobblemonExtrasConfig;", "setConfig", "(Ldev/chasem/cobblemonextras/config/CobblemonExtrasConfig;)V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "setLOGGER", "(Lorg/apache/logging/log4j/Logger;)V", "Ldev/chasem/cobblemonextras/services/ShowcaseService;", "showcaseService", "Ldev/chasem/cobblemonextras/services/ShowcaseService;", "getShowcaseService", "()Ldev/chasem/cobblemonextras/services/ShowcaseService;", "setShowcaseService", "(Ldev/chasem/cobblemonextras/services/ShowcaseService;)V", "Ldev/chasem/cobblemonextras/events/CobblemonExtrasEventHandler;", "eventHandler", "Ldev/chasem/cobblemonextras/events/CobblemonExtrasEventHandler;", "getEventHandler", "()Ldev/chasem/cobblemonextras/events/CobblemonExtrasEventHandler;", "common"})
public final class CobblemonExtras {
    @NotNull
    public static final CobblemonExtras INSTANCE = new CobblemonExtras();
    public static CobblemonExtrasPermissions permissions;
    @NotNull
    public static final String MODID = "cobblemonextras";
    public static CobblemonExtrasConfig config;
    @NotNull
    private static Logger LOGGER;
    public static ShowcaseService showcaseService;
    @NotNull
    private static final CobblemonExtrasEventHandler eventHandler;

    private CobblemonExtras() {
    }

    @NotNull
    public final CobblemonExtrasPermissions getPermissions() {
        CobblemonExtrasPermissions cobblemonExtrasPermissions = permissions;
        if (cobblemonExtrasPermissions != null) {
            return cobblemonExtrasPermissions;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"permissions");
        return null;
    }

    public final void setPermissions(@NotNull CobblemonExtrasPermissions cobblemonExtrasPermissions) {
        Intrinsics.checkNotNullParameter((Object)cobblemonExtrasPermissions, (String)"<set-?>");
        permissions = cobblemonExtrasPermissions;
    }

    @NotNull
    public final CobblemonExtrasConfig getConfig() {
        CobblemonExtrasConfig cobblemonExtrasConfig = config;
        if (cobblemonExtrasConfig != null) {
            return cobblemonExtrasConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull CobblemonExtrasConfig cobblemonExtrasConfig) {
        Intrinsics.checkNotNullParameter((Object)cobblemonExtrasConfig, (String)"<set-?>");
        config = cobblemonExtrasConfig;
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final void setLOGGER(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        LOGGER = logger;
    }

    @NotNull
    public final ShowcaseService getShowcaseService() {
        ShowcaseService showcaseService = CobblemonExtras.showcaseService;
        if (showcaseService != null) {
            return showcaseService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"showcaseService");
        return null;
    }

    public final void setShowcaseService(@NotNull ShowcaseService showcaseService) {
        Intrinsics.checkNotNullParameter((Object)showcaseService, (String)"<set-?>");
        CobblemonExtras.showcaseService = showcaseService;
    }

    @NotNull
    public final CobblemonExtrasEventHandler getEventHandler() {
        return eventHandler;
    }

    public final void initialize() {
        this.getLogger().info("CobblemonExtras - Initialized");
        this.loadConfig();
        this.getLogger().info("CobblemonExtras - Custom Model Data");
        this.getLogger().info("IV Token: " + this.getConfig().getCustomModels().getIV_TOKEN());
        this.getLogger().info("EV Token: " + this.getConfig().getCustomModels().getEV_TOKEN());
        this.getLogger().info("Nature Token: " + this.getConfig().getCustomModels().getNATURE_TOKEN());
        this.getLogger().info("Shiny Token: " + this.getConfig().getCustomModels().getSHINY_TOKEN());
        this.getLogger().info("Shiny Ball: " + this.getConfig().getCustomModels().getSHINY_BALL());
        this.setPermissions(new CobblemonExtrasPermissions());
        this.setShowcaseService(ShowcaseService.INSTANCE);
        new PokeTokensInteractionHandler();
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)CobblemonEvents.POKEMON_CAPTURED), null, CobblemonExtras::initialize$lambda$0, (int)1, null);
    }

    public final void onShutdown() {
        System.out.println("CobblemonExtras - Shutting Down");
        this.getShowcaseService().stop();
    }

    @NotNull
    public final Logger getLogger() {
        return LOGGER;
    }

    public final void loadConfig() {
        String configFileLoc = System.getProperty("user.dir") + File.separator + "config" + File.separator + MODID + File.separator + "config.json";
        System.out.println("Loading config file found at: " + configFileLoc);
        File configFile = new File(configFileLoc);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                CobblemonExtrasConfig defaultConfig = new CobblemonExtrasConfig();
                String string = CobblemonExtrasConfig.Companion.getGSON().toJson((Object)defaultConfig);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String defaultConfigJson = string;
                JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseReader(...)");
                JsonElement fileConfigElement = jsonElement;
                JsonElement jsonElement2 = JsonParser.parseString((String)defaultConfigJson);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"parseString(...)");
                JsonElement defaultConfigElement = jsonElement2;
                JsonObject jsonObject = defaultConfigElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                JsonObject jsonObject2 = fileConfigElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                JsonElement mergedConfigElement = this.mergeConfigs(jsonObject, jsonObject2);
                Object object = CobblemonExtrasConfig.Companion.getGSON().fromJson(mergedConfigElement, CobblemonExtrasConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                CobblemonExtrasConfig finalConfig = (CobblemonExtrasConfig)object;
                this.setConfig(finalConfig);
                fileReader.close();
            }
            catch (Exception e) {
                System.err.println("[CobblemonExtras] Failed to load the config! Using default config as fallback");
                e.printStackTrace();
                this.setConfig(new CobblemonExtrasConfig());
            }
        } else {
            this.setConfig(new CobblemonExtrasConfig());
        }
        this.saveConfig();
    }

    private final JsonElement mergeConfigs(JsonObject defaultConfig, JsonObject fileConfig) {
        this.getLogger().info("Checking for config merge.");
        boolean merged = false;
        for (String key : defaultConfig.keySet()) {
            if (!fileConfig.has(key)) {
                fileConfig.add(key, defaultConfig.get(key));
                this.getLogger().info("[CobblemonExtras] " + key + " not found in file config, adding from default.");
                merged = true;
                continue;
            }
            if (!defaultConfig.get(key).isJsonObject() || !fileConfig.get(key).isJsonObject()) continue;
            JsonObject jsonObject = defaultConfig.getAsJsonObject(key);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            JsonObject jsonObject2 = fileConfig.getAsJsonObject(key);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            this.mergeConfigs(jsonObject, jsonObject2);
        }
        if (merged) {
            this.getLogger().info("[CobblemonExtras] Successfully merged config.");
        }
        return (JsonElement)fileConfig;
    }

    private final void saveConfig() {
        try {
            String configFileLoc = System.getProperty("user.dir") + File.separator + "config" + File.separator + MODID + File.separator + "config.json";
            System.out.println("Saving config to: " + configFileLoc);
            File configFile = new File(configFileLoc);
            FileWriter fileWriter = new FileWriter(configFile);
            CobblemonExtrasConfig.Companion.getGSON().toJson((Object)this.getConfig(), (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            System.err.println("[CobblemonExtras] Failed to save config");
            e.printStackTrace();
        }
    }

    public final void registerCommands(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        this.getLogger().info("CobblemonExtras registerCommands");
        new CompSee().register(dispatcher);
        new PokeSee().register(dispatcher);
        new PokeShout().register(dispatcher);
        new PokeTrade().register(dispatcher);
        new Battle().register(dispatcher);
        new PokeBattle().register(dispatcher);
        new CompDelete().register(dispatcher);
        new PokeIVs().register(dispatcher);
        new PokeShoutAll().register(dispatcher);
        new EmptyBox().register(dispatcher);
        new Showcase().register(dispatcher);
        new ItemShout().register(dispatcher);
        new PokeOdds().register(dispatcher);
        new PokeKill().register(dispatcher);
        new PokeDelete().register(dispatcher);
        new GivePokeToken().register(dispatcher);
        new BattleSpectate().register(dispatcher);
        new GiveShinyBall().register(dispatcher);
    }

    private static final Unit initialize$lambda$0(PokemonCapturedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        eventHandler.onPokemonCapture(event);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogManager.getLogger((String)"[CobblemonExtras]");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        eventHandler = new CobblemonExtrasEventHandler();
    }
}

