/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import dev.chasem.cobblemonextras.services.PVPChallengeService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Ldev/chasem/cobblemonextras/commands/Battle;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "deny", "(Lcom/mojang/brigadier/context/CommandContext;)I", "execute", "common"})
@SourceDebugExtension(value={"SMAP\nBattle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Battle.kt\ndev/chasem/cobblemonextras/commands/Battle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n295#2,2:99\n*S KotlinDebug\n*F\n+ 1 Battle.kt\ndev/chasem/cobblemonextras/commands/Battle\n*L\n66#1:99,2\n*E\n"})
public final class Battle {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"battle").requires(Battle::register$lambda$0)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(arg_0 -> Battle.register$lambda$1(this, arg_0)))).then(Commands.literal((String)"deny").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(arg_0 -> Battle.register$lambda$2(this, arg_0)))));
    }

    private final int deny(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        ServerPlayer player = serverPlayer;
        ServerPlayer serverPlayer2 = EntityArgument.getPlayer(ctx, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer2, (String)"getPlayer(...)");
        ServerPlayer battlePartner = serverPlayer2;
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID uUID2 = battlePartner.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        ChallengeManager.BattleChallenge request = (ChallengeManager.BattleChallenge)PVPChallengeService.INSTANCE.getInboundRequestBySender(uUID, uUID2);
        if (request != null) {
            PVPChallengeService.INSTANCE.declineRequest(player, request.getRequestID());
        }
        return 1;
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        Object v2;
        ServerPlayer battlePartner;
        ServerPlayer player;
        block6: {
            ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
            player = serverPlayer;
            ServerPlayer serverPlayer2 = EntityArgument.getPlayer(ctx, (String)"player");
            Intrinsics.checkNotNullExpressionValue((Object)serverPlayer2, (String)"getPlayer(...)");
            battlePartner = serverPlayer2;
            if (battlePartner.getUUID().equals(player.getUUID())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Life's tough enough, don't battle yourself."));
                return 1;
            }
            if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) != null) {
                player.sendSystemMessage((Component)Component.literal((String)"You can't start a new battle, while in a battle.").withStyle(ChatFormatting.RED));
                return 1;
            }
            if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(battlePartner) != null) {
                player.sendSystemMessage((Component)Component.literal((String)"Opponent is currently in a battle.").withStyle(ChatFormatting.RED));
                return 1;
            }
            PlayerPartyStore storage1 = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$firstOrNull$iv = (Iterable)storage1;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pokemon it = (Pokemon)element$iv;
                boolean bl = false;
                if (!(!it.isFainted())) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        Pokemon firstAvailablePokemon = v2;
        if (firstAvailablePokemon == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You don't have any available Pokemon to battle with."));
            return 1;
        }
        UUID uUID = firstAvailablePokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        ChallengeManager.SinglesBattleChallenge challenge = new ChallengeManager.SinglesBattleChallenge(player, battlePartner, uUID, BattleFormat.Companion.getGEN_9_SINGLES(), 0, 16, null);
        UUID uUID2 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        UUID uUID3 = battlePartner.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        ChallengeManager.BattleChallenge request = (ChallengeManager.BattleChallenge)PVPChallengeService.INSTANCE.getInboundRequestBySender(uUID2, uUID3);
        if (request != null) {
            RequestManager.acceptRequest$default((RequestManager)PVPChallengeService.INSTANCE, (ServerPlayer)player, (UUID)request.getRequestID(), null, (int)4, null);
            return 1;
        }
        PVPChallengeService.INSTANCE.sendRequest((ServerPlayerActionRequest)challenge);
        MutableComponent accept = Component.literal((String)"[ACCEPT]").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/battle " + player.getName().getString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Accept " + player.getName().getString() + " Challenge")))));
        MutableComponent deny = Component.literal((String)"[DENY]").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/battle deny " + player.getName().getString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Deny " + player.getName().getString() + " Challenge")))));
        battlePartner.sendSystemMessage((Component)accept.copy().append(" ").append((Component)deny));
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getBATTLE_PERMISSION());
    }

    private static final int register$lambda$1(Battle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }

    private static final int register$lambda$2(Battle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.deny((CommandContext<CommandSourceStack>)ctx);
    }
}

