/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Nature;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.game.poketokens.MaxIVPokeToken;
import dev.chasem.cobblemonextras.game.poketokens.NaturePokeToken;
import dev.chasem.cobblemonextras.game.poketokens.ShinyPokeToken;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/GivePokeToken;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
@SourceDebugExtension(value={"SMAP\nGivePokeToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GivePokeToken.kt\ndev/chasem/cobblemonextras/commands/GivePokeToken\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1557#2:114\n1628#2,3:115\n1557#2:118\n1628#2,3:119\n*S KotlinDebug\n*F\n+ 1 GivePokeToken.kt\ndev/chasem/cobblemonextras/commands/GivePokeToken\n*L\n84#1:114\n84#1:115,3\n50#1:118\n50#1:119,3\n*E\n"})
public final class GivePokeToken {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"givepoketoken").requires(GivePokeToken::register$lambda$0)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.literal((String)"shiny").then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)64))).executes(arg_0 -> GivePokeToken.register$lambda$1(this, arg_0))))).then(Commands.literal((String)"maxivs").then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)64))).then(Commands.argument((String)"stats", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).suggests(GivePokeToken::register$lambda$2).executes(arg_0 -> GivePokeToken.register$lambda$3(this, arg_0)))))).then(Commands.literal((String)"nature").then(Commands.argument((String)"nature", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(GivePokeToken::register$lambda$5).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)64))).executes(arg_0 -> GivePokeToken.register$lambda$6(this, arg_0)))))));
    }

    /*
     * WARNING - void declaration
     */
    private final int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer serverPlayer = EntityArgument.getPlayer(ctx, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        ServerPlayer targettedPlayer = serverPlayer;
        String string = ctx.getInput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInput(...)");
        String[] stringArray = new String[]{" "};
        String tokenType = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(2);
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        ItemStack itemStack = null;
        int n = -1;
        switch (tokenType.hashCode()) {
            case -1052607321: {
                if (tokenType.equals("nature")) {
                    n = 1;
                }
                break;
            }
            case 109407615: {
                if (tokenType.equals("shiny")) {
                    n = 2;
                }
                break;
            }
            case -1081128702: {
                if (tokenType.equals("maxivs")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String natureText = StringArgumentType.getString(ctx, (String)"nature");
                Intrinsics.checkNotNull((Object)natureText);
                Nature nature = Natures.INSTANCE.getNature(StringsKt.replace$default((String)natureText, (String)"cobblemon.nature.", (String)"", (boolean)false, (int)4, null));
                if (nature == null) {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Nature not found."));
                    return 0;
                }
                itemStack = new NaturePokeToken(nature).generateItem(amount).build();
                break;
            }
            case 3: {
                void $this$mapTo$iv$iv;
                String statsArg = StringArgumentType.getString(ctx, (String)"stats");
                Intrinsics.checkNotNull((Object)statsArg);
                String[] stringArray2 = new String[]{" "};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)statsArg, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2;
                    void it;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    tmp = -1;
                    switch (string2.hashCode()) {
                        case 109640840: {
                            if (string2.equals("spdef")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 109638427: {
                            if (string2.equals("spatk")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 99333: {
                            if (string2.equals("def")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 114087: {
                            if (string2.equals("spd")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 3336: {
                            if (string2.equals("hp")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 96920: {
                            if (string2.equals("atk")) {
                                tmp = 6;
                            }
                            break;
                        }
                    }
                    collection.add(switch (tmp) {
                        case 5 -> Stats.HP;
                        case 6 -> Stats.ATTACK;
                        case 3 -> Stats.DEFENCE;
                        case 2 -> Stats.SPECIAL_ATTACK;
                        case 1 -> Stats.SPECIAL_DEFENCE;
                        case 4 -> Stats.SPEED;
                        default -> throw new IllegalArgumentException("Invalid stat: " + (String)it);
                    });
                }
                List stats = (List)destination$iv$iv;
                itemStack = new MaxIVPokeToken(CollectionsKt.toSet((Iterable)stats)).generateItem(amount).build();
                break;
            }
            case 2: {
                itemStack = new ShinyPokeToken().generateItem(amount).build();
            }
        }
        if (itemStack == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to create PokeToken."));
            return 0;
        }
        targettedPlayer.getInventory().add(itemStack);
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getGIVE_POKETOKEN_PERMISSION());
    }

    private static final int register$lambda$1(GivePokeToken this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }

    private static final CompletableFuture register$lambda$2(CommandContext ctx, SuggestionsBuilder builder) {
        Object[] objectArray = new String[]{"HP", "Atk", "Def", "SpAtk", "SpDef", "Spd"};
        return SharedSuggestionProvider.suggest((Iterable)CollectionsKt.listOf((Object[])objectArray), (SuggestionsBuilder)builder);
    }

    private static final int register$lambda$3(GivePokeToken this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture register$lambda$5(CommandContext ctx, SuggestionsBuilder builder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Natures.INSTANCE.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Nature nature = (Nature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDisplayName());
        }
        return SharedSuggestionProvider.suggest((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
    }

    private static final int register$lambda$6(GivePokeToken this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }
}

