/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeBattle;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class PokeBattle {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pokebattle").requires(PokeBattle::register$lambda$0)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"properties", (ArgumentType)((ArgumentType)PokemonPropertiesArgumentType.Companion.properties())).executes(arg_0 -> PokeBattle.register$lambda$1(this, arg_0)))));
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer battlingPlayer = null;
        try {
            battlingPlayer = EntityArgument.getPlayer(ctx, (String)"player");
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Error finding player."));
            return 1;
        }
        PokemonProperties pokemonProperties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(ctx, "properties");
        if (pokemonProperties.getSpecies() == null) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"No pokemon found for species provided"));
            return 1;
        }
        if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(battlingPlayer) != null) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Player is in an active battle.").withStyle(ChatFormatting.RED));
            return 1;
        }
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(battlingPlayer);
        UUID pokemonUUID = null;
        for (Pokemon pokemon : party) {
            if (pokemon.isFainted()) continue;
            pokemonUUID = pokemon.getUuid();
        }
        if (pokemonUUID == null) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Player unable to battle, no available pokemon in their party.").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).getLevel();
        Intrinsics.checkNotNull((Object)world);
        PokemonEntity pokemonEntity = PokemonProperties.createEntity$default((PokemonProperties)pokemonProperties, (Level)((Level)world), null, (int)2, null);
        pokemonEntity.moveTo(battlingPlayer.getX(), battlingPlayer.getY(), battlingPlayer.getZ(), pokemonEntity.getYRot(), pokemonEntity.getXRot());
        pokemonEntity.getEntityData().set(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.getRandom().nextFloat() * 360.0f));
        if (world.addFreshEntity((Entity)pokemonEntity)) {
            pokemonEntity.teleportTo(battlingPlayer.getX(), battlingPlayer.getY(), battlingPlayer.getZ());
            BattleBuilder.INSTANCE.pve(battlingPlayer, pokemonEntity, pokemonUUID, BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.INSTANCE.getConfig().getDefaultFleeDistance(), (PartyStore)party);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Failed to spawn Pokemon in world for player..."));
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKEBATTLE_PERMISSION());
    }

    private static final int register$lambda$1(PokeBattle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }
}

